<?php
require_once '../../includes/header.php';
require_permission(60);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $record_id = (int)$_POST['record_id'];
    $status = $_POST['status'];
    $notes = $_POST['notes'] ?? '';
    $return_date = $_POST['return_date'] ?? date('Y-m-d');
    
    try {
        $stmt = $pdo->prepare("UPDATE attendance_records 
                              SET status = ?, notes = ?, marked_by = ? 
                              WHERE id = ?");
        $stmt->execute([$status, $notes, $_SESSION['user_id'], $record_id]);
        
        log_action($pdo, 'Attendance Amended', 'attendance_records', $record_id);
        
        header('Location: dashboard.php?date=' . $return_date . '&success=Attendance updated successfully');
        exit;
        
    } catch (Exception $e) {
        header('Location: dashboard.php?date=' . $return_date . '&error=' . $e->getMessage());
        exit;
    }
} else {
    header('Location: dashboard.php');
    exit;
}