<?php
require_once 'includes/database.php';

header('Content-Type: text/plain');
echo "=== Updating sponsored_workers table with comprehensive fields ===\n\n";

try {
    $pdo = get_db_connection();

    // Get existing columns
    $stmt = $pdo->query("SHOW COLUMNS FROM scms_sponsored_workers");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $existing = array_column($columns, 'Field');

    echo "Current columns: " . count($existing) . "\n\n";

    // Define all new fields needed
    $new_fields = [
        // Identity & Right to Work
        "passport_number VARCHAR(50) AFTER nationality",
        "passport_expiry DATE AFTER passport_number",
        "passport_issue_date DATE AFTER passport_expiry",
        "passport_country VARCHAR(100) AFTER passport_issue_date",
        "brp_number VARCHAR(20) AFTER passport_country",
        "brp_expiry DATE AFTER brp_number",
        "share_code VARCHAR(20) AFTER brp_expiry",
        "share_code_expiry DATE AFTER share_code",
        "driving_license VARCHAR(50) AFTER ni_number",
        "gender VARCHAR(20) AFTER date_of_birth",
        "place_of_birth VARCHAR(100) AFTER gender",

        // Visa Information (comprehensive)
        "visa_number VARCHAR(50) AFTER visa_type",
        "visa_issue_date DATE AFTER visa_number",
        "visa_expiry_date DATE AFTER visa_expiry", // Keep both for compatibility
        "visa_status VARCHAR(50) AFTER visa_expiry_date",
        "indefinite_leave TINYINT(1) DEFAULT 0 AFTER visa_status",
        "settled_status TINYINT(1) DEFAULT 0 AFTER indefinite_leave",
        "pre_settled_status TINYINT(1) DEFAULT 0 AFTER settled_status",

        // CoS Information
        "cos_issue_date DATE AFTER cos_number",
        "cos_start_date DATE AFTER cos_issue_date",
        "cos_end_date DATE AFTER cos_start_date",
        "sponsor_license_number VARCHAR(50) AFTER cos_end_date",

        // Immigration History
        "previous_visa_type VARCHAR(100) AFTER sponsor_license_number",
        "entry_clearance_number VARCHAR(50) AFTER previous_visa_type",
        "biometric_id VARCHAR(50) AFTER entry_clearance_number",

        // Banking & Tax
        "bank_name VARCHAR(100) AFTER emergency_phone",
        "bank_account_number VARCHAR(20) AFTER bank_name",
        "bank_sort_code VARCHAR(10) AFTER bank_account_number",
        "tax_code VARCHAR(20) AFTER bank_sort_code",

        // Emergency Contact Extended
        "emergency_contact_relationship VARCHAR(50) AFTER emergency_phone",
        "emergency_contact_address TEXT AFTER emergency_contact_relationship",
        "secondary_emergency_contact VARCHAR(100) AFTER emergency_contact_address",
        "secondary_emergency_phone VARCHAR(20) AFTER secondary_emergency_contact",
        "secondary_emergency_relationship VARCHAR(50) AFTER secondary_emergency_phone",

        // Employment Extended
        "annual_salary DECIMAL(10,2) AFTER contract_type",
        "hourly_rate DECIMAL(10,2) AFTER annual_salary",
        "work_hours_per_week DECIMAL(5,2) AFTER hourly_rate",
        "probation_end_date DATE AFTER start_date",
        "line_manager VARCHAR(100) AFTER department",

        // Additional Contact
        "postcode VARCHAR(10) AFTER address",
        "city VARCHAR(100) AFTER postcode",
        "country VARCHAR(100) DEFAULT 'United Kingdom' AFTER city",
        "personal_email VARCHAR(255) AFTER email",
        "mobile_phone VARCHAR(20) AFTER phone",

        // Notes & Documents
        "notes TEXT AFTER status",
        "right_to_work_checked TINYINT(1) DEFAULT 0 AFTER notes",
        "right_to_work_check_date DATE AFTER right_to_work_checked",
        "right_to_work_expiry DATE AFTER right_to_work_check_date",
        "documents_verified_by VARCHAR(100) AFTER right_to_work_expiry"
    ];

    $added = 0;
    $skipped = 0;

    foreach ($new_fields as $field_def) {
        // Extract field name
        preg_match('/^(\w+)\s/', $field_def, $matches);
        $field_name = $matches[1];

        if (in_array($field_name, $existing)) {
            echo "- Skipped: $field_name (already exists)\n";
            $skipped++;
            continue;
        }

        try {
            $sql = "ALTER TABLE scms_sponsored_workers ADD COLUMN $field_def";
            $pdo->exec($sql);
            echo "✓ Added: $field_name\n";
            $added++;
        } catch (PDOException $e) {
            if (strpos($e->getMessage(), 'Duplicate column') !== false) {
                echo "- Skipped: $field_name (duplicate)\n";
                $skipped++;
            } else {
                echo "✗ Error adding $field_name: " . $e->getMessage() . "\n";
            }
        }
    }

    echo "\n=== Summary ===\n";
    echo "Added: $added fields\n";
    echo "Skipped: $skipped fields\n";
    echo "\n✓ Database update complete!\n";

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage();
}
