<?php
/**
 * Update module names in the registry to shorter sidebar names
 */

require_once 'config/database.php';
require_once 'includes/database.php';

try {
    $pdo = get_database_connection();

    // Update Attendance Management to just Attendance
    $stmt = $pdo->prepare("UPDATE " . DB_PREFIX . "modules_registry SET module_name = ? WHERE module_id = ?");

    $updates = [
        ['module_id' => 'attendance', 'name' => 'Attendance'],
        // Add other updates if needed
    ];

    foreach ($updates as $update) {
        $stmt->execute([$update['name'], $update['module_id']]);
        echo "✓ Updated {$update['module_id']} to '{$update['name']}'\n";
    }

    echo "\nCurrent module names:\n";
    echo str_repeat('-', 50) . "\n";

    $stmt = $pdo->query("SELECT module_id, module_name FROM " . DB_PREFIX . "modules_registry ORDER BY sort_order ASC, module_name ASC");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo sprintf("%-20s => %s\n", $row['module_id'], $row['module_name']);
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
