<?php
require_once 'config/database.php';

try {
    // Add/update immigration-related fields
    $new_fields = [
        // EU Settlement fields
        "eu_settlement_scheme_type ENUM('settled', 'pre_settled', 'none') DEFAULT 'none' AFTER nationality",
        "euss_start_date DATE AFTER eu_settlement_scheme_type",
        "euss_expiry_date DATE AFTER euss_start_date",

        // More comprehensive visa fields
        "visa_vignette_number VARCHAR(50) AFTER visa_number",
        "current_visa_start_date DATE AFTER visa_issue_date",
        "biometric_residence_permit VARCHAR(50) AFTER brp_number",

        // Settlement tracking
        "ilr_date DATE AFTER indefinite_leave",
        "settled_status_date DATE AFTER settled_status",
        "pre_settled_start_date DATE AFTER pre_settled_status",

        // Additional document tracking
        "residence_card_number VARCHAR(50) AFTER share_code_expiry",
        "residence_card_expiry DATE AFTER residence_card_number",

        // Immigration history
        "previous_visa_type VARCHAR(100) AFTER visa_status",
        "visa_refusal_history TINYINT(1) DEFAULT 0 AFTER previous_visa_type",
        "immigration_notes TEXT AFTER visa_refusal_history"
    ];

    foreach ($new_fields as $field_def) {
        try {
            $sql = "ALTER TABLE " . DB_PREFIX . "sponsored_workers ADD COLUMN $field_def";
            $pdo->exec($sql);
            echo "✓ Added field: " . explode(' ', $field_def)[0] . "\n";
        } catch (PDOException $e) {
            // Field might already exist
            if (strpos($e->getMessage(), 'Duplicate column') === false) {
                echo "⚠ Warning for field " . explode(' ', $field_def)[0] . ": " . $e->getMessage() . "\n";
            }
        }
    }

    echo "\n✓ Immigration fields update completed successfully!\n";

} catch (PDOException $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    exit(1);
}
?>
