<?php
require_once 'config/database.php';

try {
    // Update the enum to support new_hire and keep backward compatibility
    $sql = "ALTER TABLE " . DB_PREFIX . "sponsored_workers
            MODIFY COLUMN employment_status ENUM('new_hire', 'pre_employment', 'active', 'suspended', 'terminated', 'on_leave')
            DEFAULT 'new_hire'";

    $pdo->exec($sql);
    echo "✓ Updated employment_status enum to include 'new_hire'\n";

    // Migrate any 'active' status to 'new_hire' for new records
    $update_sql = "UPDATE " . DB_PREFIX . "sponsored_workers
                   SET employment_status = 'new_hire'
                   WHERE employment_status = 'active' AND created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)";

    $stmt = $pdo->exec($update_sql);
    echo "✓ Migrated recent 'active' statuses to 'new_hire': $stmt rows affected\n";

    echo "\n✓ Employment status enum updated successfully!\n";

} catch (PDOException $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    exit(1);
}
?>
