<?php
require_once 'config/database.php';
require_once 'includes/database.php';

try {
    echo "Testing users query...\n\n";

    $stmt = $pdo->query("SELECT id, username, full_name, email, phone, user_role, permission_level, status,
                         last_login, last_login_ip, login_count, created_at
                         FROM " . DB_PREFIX . "users
                         ORDER BY permission_level DESC, full_name ASC");
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "Found " . count($users) . " users:\n\n";

    foreach ($users as $user) {
        echo "ID: " . $user['id'] . "\n";
        echo "Username: " . $user['username'] . "\n";
        echo "Full Name: " . $user['full_name'] . "\n";
        echo "Email: " . $user['email'] . "\n";
        echo "Status: " . $user['status'] . "\n";
        echo "Permission Level: " . $user['permission_level'] . "\n";
        echo "---\n";
    }

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
