<?php
require_once 'config/database.php';
require_once 'includes/database.php';

$pdo = get_database_connection();

// Check if locations module is registered
echo "=== Checking Locations Module Registration ===\n";
$stmt = $pdo->query("SELECT module_id, name, status FROM scms_modules_registry WHERE module_id = 'locations'");
$module = $stmt->fetch(PDO::FETCH_ASSOC);

if ($module) {
    echo "Module found:\n";
    echo "  - ID: " . $module['module_id'] . "\n";
    echo "  - Name: " . $module['name'] . "\n";
    echo "  - Status: " . $module['status'] . "\n";
} else {
    echo "Locations module is NOT registered in scms_modules_registry!\n";
    echo "Need to insert registration record.\n";
}

echo "\n=== Checking work_locations table ===\n";
try {
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM scms_work_locations");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "Total locations: " . $result['count'] . "\n";

    $stmt = $pdo->query("SELECT id, name, status FROM scms_work_locations LIMIT 5");
    $locations = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if ($locations) {
        echo "\nFirst 5 locations:\n";
        foreach ($locations as $loc) {
            echo "  - ID {$loc['id']}: {$loc['name']} ({$loc['status']})\n";
        }
    }
} catch (PDOException $e) {
    echo "Error accessing work_locations: " . $e->getMessage() . "\n";
}

echo "\n=== Checking workers with locations ===\n";
try {
    $stmt = $pdo->query("SELECT id, full_name, location_id FROM scms_sponsored_workers WHERE location_id IS NOT NULL LIMIT 5");
    $workers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if ($workers) {
        echo "Workers with locations:\n";
        foreach ($workers as $w) {
            echo "  - Worker {$w['id']}: {$w['full_name']} -> Location ID {$w['location_id']}\n";
        }
    } else {
        echo "No workers have locations assigned yet.\n";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
