<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require 'config/database.php';
require 'includes/database.php';

$pdo = get_database_connection();

echo "Testing attendance module...\n\n";

// Check if attendance_records table exists
try {
    $result = $pdo->query("SHOW TABLES LIKE 'scms_attendance_records'");
    if ($result->rowCount() > 0) {
        echo "✓ scms_attendance_records table EXISTS\n";
    } else {
        echo "✗ scms_attendance_records table MISSING\n";
    }
} catch (Exception $e) {
    echo "✗ Error checking table: " . $e->getMessage() . "\n";
}

// Check if workers table has records
try {
    $result = $pdo->query("SELECT COUNT(*) FROM scms_sponsored_workers WHERE status = 'active'");
    $count = $result->fetchColumn();
    echo "✓ Active workers: $count\n";
} catch (Exception $e) {
    echo "✗ Error checking workers: " . $e->getMessage() . "\n";
}

// Test the exact query from calendar.php
try {
    $workers_sql = "SELECT id, full_name, employee_number, department FROM scms_sponsored_workers WHERE status = 'active' ORDER BY full_name";
    $workers = $pdo->query($workers_sql)->fetchAll(PDO::FETCH_ASSOC);
    echo "✓ Workers query returned: " . count($workers) . " workers\n";
} catch (Exception $e) {
    echo "✗ Workers query failed: " . $e->getMessage() . "\n";
}
