<?php
/**
 * Migration Script - Create modules_registry table
 */
require_once 'config/database.php';
require_once 'includes/database.php';

header('Content-Type: text/plain');

echo "SCMS Module Registry Migration\n";
echo str_repeat('=', 50) . "\n\n";

try {
    $pdo = get_database_connection();

    // Read SQL file
    $sql_file = __DIR__ . '/create_modules_registry.sql';
    if (!file_exists($sql_file)) {
        die("❌ Error: SQL file not found: $sql_file\n");
    }

    $sql = file_get_contents($sql_file);

    // Execute SQL
    echo "Executing migration...\n";
    $pdo->exec($sql);

    echo "✅ Table scms_modules_registry created successfully!\n\n";

    // Verify table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'scms_modules_registry'");
    if ($stmt->fetch()) {
        echo "✅ Verification: Table exists\n\n";

        // Show table structure
        echo "Table Structure:\n";
        echo str_repeat('-', 50) . "\n";
        $stmt = $pdo->query("DESCRIBE scms_modules_registry");
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            printf("%-20s | %-15s | %s\n",
                   $row['Field'],
                   $row['Type'],
                   $row['Null'] === 'YES' ? 'NULL' : 'NOT NULL');
        }

        echo "\n✅ Migration completed successfully!\n";
        echo "\nYou can now install modules from Settings → Modules tab.\n";
    } else {
        echo "❌ Error: Table verification failed\n";
    }

} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "\nStack trace:\n" . $e->getTraceAsString() . "\n";
}
?>
