<?php
/**
 * RIU Registration Status Check
 */
session_start();
?>
<!DOCTYPE html>
<html>
<head>
    <title>RIU Status Check</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0"><i class="bi bi-cloud-check"></i> RIU Registration Status</h4>
            </div>
            <div class="card-body">
                <h5>Session Data:</h5>
                <table class="table table-bordered">
                    <tr>
                        <th width="30%">License Key</th>
                        <td><?php echo isset($_SESSION['license_key']) ? htmlspecialchars($_SESSION['license_key']) : '<span class="text-danger">NOT SET</span>'; ?></td>
                    </tr>
                    <tr>
                        <th>Domain</th>
                        <td><?php echo isset($_SESSION['domain']) ? htmlspecialchars($_SESSION['domain']) : '<span class="text-danger">NOT SET</span>'; ?></td>
                    </tr>
                    <tr>
                        <th>RIU Registered</th>
                        <td>
                            <?php if (isset($_SESSION['riu_registered']) && $_SESSION['riu_registered']): ?>
                                <span class="badge bg-success">YES</span>
                            <?php else: ?>
                                <span class="badge bg-danger">NO</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th>RIU Access Token</th>
                        <td><?php echo isset($_SESSION['riu_access_token']) ? '<code>' . substr($_SESSION['riu_access_token'], 0, 20) . '...</code>' : '<span class="text-danger">NOT SET</span>'; ?></td>
                    </tr>
                    <tr>
                        <th>RIU Instance ID</th>
                        <td><?php echo isset($_SESSION['riu_instance_id']) ? '<code>' . htmlspecialchars($_SESSION['riu_instance_id']) . '</code>' : '<span class="text-danger">NOT SET</span>'; ?></td>
                    </tr>
                    <tr>
                        <th>RIU Error</th>
                        <td>
                            <?php if (isset($_SESSION['riu_error'])): ?>
                                <span class="text-danger"><?php echo htmlspecialchars($_SESSION['riu_error']); ?></span>
                            <?php else: ?>
                                <span class="text-muted">None</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>

                <h5 class="mt-4">Test RIU Connection:</h5>
                <p><a href="test_riu.php" class="btn btn-primary">Run RIU Communication Test</a></p>

                <h5 class="mt-4">Error Log (Last 20 lines):</h5>
                <div class="bg-dark text-white p-3" style="font-family: monospace; font-size: 12px; max-height: 400px; overflow-y: auto;">
                    <?php
                    $log_file = __DIR__ . '/error_log';
                    if (file_exists($log_file)) {
                        $lines = file($log_file);
                        $last_lines = array_slice($lines, -20);
                        foreach ($last_lines as $line) {
                            if (stripos($line, 'riu') !== false || stripos($line, 'scms') !== false) {
                                echo '<span class="text-warning">' . htmlspecialchars($line) . '</span>';
                            } else {
                                echo htmlspecialchars($line);
                            }
                        }
                    } else {
                        echo "No error log found";
                    }
                    ?>
                </div>
            </div>
            <div class="card-footer">
                <a href="install.php" class="btn btn-secondary">Back to Installer</a>
                <a href="?clear=1" class="btn btn-warning">Clear Session</a>
            </div>
        </div>
    </div>
</body>
</html>

<?php
if (isset($_GET['clear'])) {
    session_destroy();
    header('Location: riu_status.php');
    exit;
}
?>
