<?php
/**
 * Reset all modules to uninstalled state
 */
session_start();
require_once 'config/database.php';
require_once 'includes/database.php';

try {
    $pdo = get_database_connection();

    echo "<!DOCTYPE html>
<html>
<head>
    <title>Reset Modules</title>
    <link href='https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css' rel='stylesheet'>
</head>
<body>
<div class='container mt-5'>
    <h2>Reset Modules</h2>";

    // Truncate the table
    $pdo->exec("TRUNCATE TABLE scms_modules_registry");

    echo "<div class='alert alert-success'>
        <h4>✓ All modules reset successfully!</h4>
        <p>All modules have been removed from the registry. They will now appear in the 'Discovered Modules' section.</p>
    </div>";

    echo "<a href='settings.php' class='btn btn-primary'>Go to Module Manager</a>";

    echo "</div></body></html>";

} catch (Exception $e) {
    echo "<div class='alert alert-danger'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
}
?>
