<?php
require_once 'config/database.php';

try {
    echo "Registering Locations Module...\n";

    // Register the module
    $sql = "INSERT INTO scms_modules_registry (module_id, name, description, version, status, has_menu, menu_label, menu_icon, menu_order, created_at)
            VALUES (
                'locations',
                'Locations Management',
                'Manage work locations with shift timings and worker assignments',
                '1.0.0',
                'active',
                1,
                'Locations',
                'bi-geo-alt',
                50,
                NOW()
            )
            ON DUPLICATE KEY UPDATE
                status = 'active',
                has_menu = 1,
                menu_label = 'Locations',
                menu_icon = 'bi-geo-alt',
                updated_at = NOW()";

    $pdo->exec($sql);
    echo "✓ Locations module registered successfully!\n\n";

    // Verify
    $stmt = $pdo->query("SELECT module_id, name, status, has_menu FROM scms_modules_registry WHERE module_id = 'locations'");
    $module = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($module) {
        echo "Module details:\n";
        echo "  ID: " . $module['module_id'] . "\n";
        echo "  Name: " . $module['name'] . "\n";
        echo "  Status: " . $module['status'] . "\n";
        echo "  Has Menu: " . ($module['has_menu'] ? 'Yes' : 'No') . "\n";
    }

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
