<?php
/**
 * Database Migration: Add new worker status values
 * Adds 'pre_employment' and 'pending_rtw' to the status ENUM
 */

require_once '../../config/database.php';

echo "<h2>Updating Worker Status ENUM...</h2>";

try {
    $pdo = get_database_connection();

    // Check current ENUM values
    $stmt = $pdo->query("SHOW COLUMNS FROM " . DB_PREFIX . "sponsored_workers LIKE 'status'");
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        echo "<p>Current status ENUM: " . htmlspecialchars($row['Type']) . "</p>";

        // Alter table to add new status values
        $sql = "ALTER TABLE " . DB_PREFIX . "sponsored_workers
                MODIFY COLUMN status ENUM('active', 'inactive', 'terminated', 'deleted', 'pre_employment', 'pending_rtw')
                DEFAULT 'active'";

        $pdo->exec($sql);

        echo "<p style='color: green;'>✓ Successfully updated status ENUM to include:</p>";
        echo "<ul>";
        echo "<li><strong>active</strong> - Worker is active (British/Irish or RTW check passed)</li>";
        echo "<li><strong>pre_employment</strong> - Worker awaiting visa (not in UK yet)</li>";
        echo "<li><strong>pending_rtw</strong> - Worker in UK but needs RTW check</li>";
        echo "<li><strong>inactive</strong> - Worker is inactive</li>";
        echo "<li><strong>terminated</strong> - Worker employment terminated</li>";
        echo "<li><strong>deleted</strong> - Soft deleted worker</li>";
        echo "</ul>";

        // Check updated ENUM
        $stmt = $pdo->query("SHOW COLUMNS FROM " . DB_PREFIX . "sponsored_workers LIKE 'status'");
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "<p>Updated status ENUM: " . htmlspecialchars($row['Type']) . "</p>";

        echo "<hr>";
        echo "<h3 style='color: green;'>Migration Successful!</h3>";
        echo "<p><a href='list.php'>Go to Workers List</a></p>";

    } else {
        echo "<p style='color: red;'>✗ Could not find status column</p>";
    }

} catch (PDOException $e) {
    echo "<p style='color: red;'>✗ Error: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>
