<?php
// This file handles the POST processing for add.php
// Include at the top of add.php after session_start and authentication

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $employee_number = trim($_POST['employee_number'] ?? '');
    $first_name = trim($_POST['first_name'] ?? '');
    $middle_name = trim($_POST['middle_name'] ?? '');
    $last_name = trim($_POST['last_name'] ?? '');
    $nationality = trim($_POST['nationality'] ?? '');

    // Validate required fields
    if (empty($employee_number)) $errors[] = "Employee number required";
    if (empty($first_name)) $errors[] = "First name required";
    if (empty($last_name)) $errors[] = "Last name required";
    if (empty($nationality)) $errors[] = "Nationality required";

    // Nationality-based validation
    $is_british = (strtolower($nationality) === 'british' || strtolower($nationality) === 'irish');

    if (!$is_british) {
        if (empty($_POST['visa_type'])) $errors[] = "Visa/immigration status required for non-British/Irish nationals";
    }

    // Check duplicate employee number
    if (!empty($employee_number) && empty($errors)) {
        $check = $pdo->prepare("SELECT id FROM scms_sponsored_workers WHERE employee_number = ?");
        $check->execute([$employee_number]);
        if ($check->fetch()) $errors[] = "Employee number already exists";
    }

    if (empty($errors)) {
        // Build full name
        $full_name = $first_name;
        if (!empty($middle_name)) $full_name .= ' ' . $middle_name;
        $full_name .= ' ' . $last_name;

        try {
            $pdo->beginTransaction();

            // Insert main worker record
            $stmt = $pdo->prepare("INSERT INTO scms_sponsored_workers
                (employee_number, full_name, date_of_birth, gender, place_of_birth, nationality,
                 passport_number, passport_issue_date, passport_expiry, passport_country,
                 ni_number, driving_license,
                 brp_number, brp_expiry, share_code, share_code_expiry,
                 visa_type, visa_number, visa_issue_date, visa_expiry, visa_status,
                 indefinite_leave, settled_status, pre_settled_status,
                 cos_number, cos_issue_date, cos_start_date, cos_end_date,
                 right_to_work_checked, right_to_work_check_date, right_to_work_expiry,
                 email, personal_email, phone, mobile_phone,
                 address, city, postcode, country,
                 emergency_contact, emergency_phone, emergency_contact_relationship, emergency_contact_address,
                 secondary_emergency_contact, secondary_emergency_phone, secondary_emergency_relationship,
                 job_title, department, line_manager, contract_type,
                 start_date, probation_end_date, annual_salary, hourly_rate, work_hours_per_week,
                 bank_name, bank_account_number, bank_sort_code, tax_code,
                 notes, status, created_at)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'active', NOW())");

            $stmt->execute([
                $employee_number,
                $full_name,
                $_POST['date_of_birth'] ?: null,
                $_POST['gender'] ?: null,
                $_POST['place_of_birth'] ?: null,
                $nationality,
                $_POST['passport_number'] ?: null,
                $_POST['passport_issue_date'] ?: null,
                $_POST['passport_expiry'] ?: null,
                $_POST['passport_country'] ?: null,
                $_POST['ni_number'] ?: null,
                $_POST['driving_license'] ?: null,
                $_POST['brp_number'] ?: null,
                $_POST['brp_expiry'] ?: null,
                $_POST['share_code'] ?: null,
                $_POST['share_code_expiry'] ?: null,
                $_POST['visa_type'] ?: null,
                $_POST['visa_number'] ?: null,
                $_POST['visa_issue_date'] ?: null,
                $_POST['visa_expiry'] ?: null,
                $_POST['visa_status'] ?: null,
                isset($_POST['indefinite_leave']) ? 1 : 0,
                isset($_POST['settled_status']) ? 1 : 0,
                isset($_POST['pre_settled_status']) ? 1 : 0,
                $_POST['cos_number'] ?: null,
                $_POST['cos_issue_date'] ?: null,
                $_POST['cos_start_date'] ?: null,
                $_POST['cos_end_date'] ?: null,
                isset($_POST['right_to_work_checked']) ? 1 : 0,
                $_POST['right_to_work_check_date'] ?: null,
                $_POST['right_to_work_expiry'] ?: null,
                $_POST['email'] ?: null,
                $_POST['personal_email'] ?: null,
                $_POST['phone'] ?: null,
                $_POST['mobile_phone'] ?: null,
                $_POST['address'] ?: null,
                $_POST['city'] ?: null,
                $_POST['postcode'] ?: null,
                $_POST['country'] ?: 'United Kingdom',
                $_POST['emergency_contact'] ?: null,
                $_POST['emergency_phone'] ?: null,
                $_POST['emergency_contact_relationship'] ?: null,
                $_POST['emergency_contact_address'] ?: null,
                $_POST['secondary_emergency_contact'] ?: null,
                $_POST['secondary_emergency_phone'] ?: null,
                $_POST['secondary_emergency_relationship'] ?: null,
                $_POST['job_title'] ?: null,
                $_POST['department'] ?: null,
                $_POST['line_manager'] ?: null,
                $_POST['contract_type'] ?: null,
                $_POST['start_date'] ?: null,
                $_POST['probation_end_date'] ?: null,
                $_POST['annual_salary'] ?: null,
                $_POST['hourly_rate'] ?: null,
                $_POST['work_hours_per_week'] ?: null,
                $_POST['bank_name'] ?: null,
                $_POST['bank_account_number'] ?: null,
                $_POST['bank_sort_code'] ?: null,
                $_POST['tax_code'] ?: null,
                $_POST['notes'] ?: null
            ]);

            $worker_id = $pdo->lastInsertId();

            // Insert current address as first address history entry
            if (!empty($_POST['address'])) {
                $stmt_addr = $pdo->prepare("INSERT INTO scms_worker_address_history
                    (worker_id, address_type, address_line1, city, postcode, country, move_in_date, is_current)
                    VALUES (?, 'current', ?, ?, ?, ?, ?, 1)");
                $stmt_addr->execute([
                    $worker_id,
                    $_POST['address'],
                    $_POST['city'] ?: null,
                    $_POST['postcode'] ?: null,
                    $_POST['country'] ?: 'United Kingdom',
                    $_POST['start_date'] ?: date('Y-m-d')
                ]);
            }

            // Insert address history entries
            if (!empty($_POST['address_history'])) {
                $stmt_addr_hist = $pdo->prepare("INSERT INTO scms_worker_address_history
                    (worker_id, address_type, address_line1, address_line2, city, county, postcode, country, move_in_date, move_out_date, notes)
                    VALUES (?, 'previous', ?, ?, ?, ?, ?, ?, ?, ?, ?)");

                foreach ($_POST['address_history'] as $addr) {
                    if (!empty($addr['address_line1'])) {
                        $stmt_addr_hist->execute([
                            $worker_id,
                            $addr['address_line1'],
                            $addr['address_line2'] ?? null,
                            $addr['city'] ?? null,
                            $addr['county'] ?? null,
                            $addr['postcode'] ?? null,
                            $addr['country'] ?? 'United Kingdom',
                            $addr['move_in_date'] ?? null,
                            $addr['move_out_date'] ?? null,
                            $addr['notes'] ?? null
                        ]);
                    }
                }
            }

            // Insert qualifications
            if (!empty($_POST['qualifications'])) {
                $stmt_qual = $pdo->prepare("INSERT INTO scms_worker_qualifications
                    (worker_id, qualification_type, qualification_name, issuing_organization, qualification_level,
                     field_of_study, certificate_number, issue_date, expiry_date, grade_result, country, notes)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

                foreach ($_POST['qualifications'] as $qual) {
                    if (!empty($qual['qualification_name'])) {
                        $stmt_qual->execute([
                            $worker_id,
                            $qual['qualification_type'] ?? 'professional',
                            $qual['qualification_name'],
                            $qual['issuing_organization'] ?? null,
                            $qual['qualification_level'] ?? null,
                            $qual['field_of_study'] ?? null,
                            $qual['certificate_number'] ?? null,
                            $qual['issue_date'] ?? null,
                            $qual['expiry_date'] ?? null,
                            $qual['grade_result'] ?? null,
                            $qual['country'] ?? null,
                            $qual['notes'] ?? null
                        ]);
                    }
                }
            }

            $pdo->commit();

            header('Location: view.php?id=' . $worker_id . '&success=1');
            exit;

        } catch (PDOException $e) {
            $pdo->rollBack();
            $errors[] = "Database error: " . $e->getMessage();
        }
    }
}
