<?php
session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';

$pdo = get_database_connection();
$worker_id = $_GET['id'] ?? 1;

echo "<h2>Debug Location Assignments for Worker ID: $worker_id</h2>";

// Check if table exists
try {
    $stmt = $pdo->query("SHOW TABLES LIKE '" . DB_PREFIX . "worker_location_assignments'");
    $table_exists = $stmt->fetch();

    if ($table_exists) {
        echo "<p style='color:green;'>✓ Table exists: " . DB_PREFIX . "worker_location_assignments</p>";

        // Get all assignments for this worker
        $stmt = $pdo->prepare("SELECT * FROM " . DB_PREFIX . "worker_location_assignments WHERE worker_id = ?");
        $stmt->execute([$worker_id]);
        $assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);

        echo "<h3>Raw Assignments Data:</h3>";
        echo "<pre>" . print_r($assignments, true) . "</pre>";

        // Get assignments with JOIN
        $stmt = $pdo->prepare("SELECT
            wla.*,
            l.name as location_name,
            l.type as location_type,
            l.address as location_address,
            l.city as location_city,
            l.postcode as location_postcode,
            l.capacity as location_capacity,
            l.status as location_status,
            sp.shift_name,
            sp.shift_type,
            sp.start_time,
            sp.end_time,
            sp.break_duration,
            sp.days_of_week as shift_days_of_week
            FROM " . DB_PREFIX . "worker_location_assignments wla
            LEFT JOIN " . DB_PREFIX . "work_locations l ON wla.location_id = l.id
            LEFT JOIN " . DB_PREFIX . "location_shift_patterns sp ON wla.shift_pattern_id = sp.id
            WHERE wla.worker_id = ?
                AND (wla.end_date IS NULL OR wla.end_date >= CURDATE())
            ORDER BY wla.is_primary DESC, wla.id ASC");
        $stmt->execute([$worker_id]);
        $assignments_with_join = $stmt->fetchAll(PDO::FETCH_ASSOC);

        echo "<h3>Assignments with JOIN:</h3>";
        echo "<pre>" . print_r($assignments_with_join, true) . "</pre>";

    } else {
        echo "<p style='color:red;'>✗ Table does NOT exist: " . DB_PREFIX . "worker_location_assignments</p>";
    }

    // Check if locations module is active
    $stmt = $pdo->query("SELECT status FROM " . DB_PREFIX . "modules_registry WHERE module_id = 'locations'");
    $module = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<h3>Locations Module Status:</h3>";
    echo "<pre>" . print_r($module, true) . "</pre>";

} catch (PDOException $e) {
    echo "<p style='color:red;'>Error: " . $e->getMessage() . "</p>";
}
?>
