<?php
/**
 * Worker Activation Table Setup
 * Tracks worker activation history and details
 */

require_once '../../config/database.php';
require_once '../../includes/database.php';

$pdo = get_database_connection();

echo "Creating Worker Activation Table...\n\n";

try {
    // Worker Activation History Table
    $sql = "CREATE TABLE IF NOT EXISTS " . DB_PREFIX . "worker_activation (
        activation_id INT AUTO_INCREMENT PRIMARY KEY,
        worker_id INT NOT NULL,
        activated_by INT NOT NULL,
        activation_date DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
        start_date DATE NOT NULL,
        previous_status VARCHAR(50),
        new_status VARCHAR(50) DEFAULT 'active',
        rtw_check_id INT NULL,
        activation_notes TEXT,
        confirmed_details JSON COMMENT 'Stores confirmed worker details at activation',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (worker_id) REFERENCES " . DB_PREFIX . "sponsored_workers(id) ON DELETE CASCADE,
        INDEX idx_worker_id (worker_id),
        INDEX idx_activation_date (activation_date)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

    $pdo->exec($sql);
    echo "✓ Created worker_activation table\n";
    echo "  - Tracks activation history\n";
    echo "  - Links to RTW checks\n";
    echo "  - Stores confirmed details as JSON\n\n";

    // Check if table exists
    $stmt = $pdo->query("SHOW TABLES LIKE '" . DB_PREFIX . "worker_activation'");
    if ($stmt->rowCount() > 0) {
        echo "✓ Table verification successful\n\n";

        // Show table structure
        echo "Table Structure:\n";
        $stmt = $pdo->query("DESCRIBE " . DB_PREFIX . "worker_activation");
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            echo "  - {$row['Field']} ({$row['Type']})\n";
        }
    }

} catch (PDOException $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
}

echo "\n✓ Worker activation system ready!\n";
?>
