<?php
/**
 * Check and Update Worker Status ENUM
 */

require_once '../../config/database.php';
require_once '../../includes/database.php';

try {
    $pdo = get_database_connection();

    echo "Checking current status ENUM...\n\n";

    // Check current ENUM values
    $stmt = $pdo->query("SHOW COLUMNS FROM " . DB_PREFIX . "sponsored_workers LIKE 'status'");
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        echo "Current ENUM: " . $row['Type'] . "\n\n";

        // Check if new values already exist
        if (strpos($row['Type'], 'pre_employment') !== false) {
            echo "✓ Status ENUM already includes 'pre_employment' and 'pending_rtw'\n";
            echo "No migration needed.\n";
        } else {
            echo "Updating status ENUM to add new values...\n";

            // Alter table to add new status values
            $sql = "ALTER TABLE " . DB_PREFIX . "sponsored_workers
                    MODIFY COLUMN status ENUM('active', 'inactive', 'terminated', 'deleted', 'pre_employment', 'pending_rtw')
                    DEFAULT 'active'";

            $pdo->exec($sql);

            echo "✓ Successfully updated status ENUM\n\n";

            // Verify update
            $stmt = $pdo->query("SHOW COLUMNS FROM " . DB_PREFIX . "sponsored_workers LIKE 'status'");
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            echo "New ENUM: " . $row['Type'] . "\n";
        }
    } else {
        echo "✗ Could not find status column\n";
    }

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
