// Address History Management
let addressHistoryCount = 0;
let addressHistoryType = 'none';
let addressHistoryStartDate = null;

document.addEventListener('DOMContentLoaded', function() {
    const addressTypeSelect = document.getElementById('addressHistoryType');
    if (addressTypeSelect) {
        addressTypeSelect.addEventListener('change', function() {
            handleAddressHistoryTypeChange(this.value);
        });
    }
});

function handleAddressHistoryTypeChange(type) {
    addressHistoryType = type;
    const container = document.getElementById('addressHistoryContainer');
    const periodInfo = document.getElementById('addressPeriodInfo');

    if (type === 'none') {
        container.style.display = 'none';
        return;
    }

    container.style.display = 'block';

    const today = new Date();
    let requiredFromDate;

    if (type === '3years') {
        requiredFromDate = new Date(today.setFullYear(today.getFullYear() - 3));
        periodInfo.textContent = `Please provide address history from ${requiredFromDate.toLocaleDateString('en-GB')} to present`;
    } else if (type === '5years') {
        requiredFromDate = new Date(today.setFullYear(today.getFullYear() - 5));
        periodInfo.textContent = `Please provide address history from ${requiredFromDate.toLocaleDateString('en-GB')} to present`;
    } else {
        periodInfo.textContent = 'Add any previous addresses as needed';
    }

    addressHistoryStartDate = requiredFromDate;
}

function addAddressHistory() {
    addressHistoryCount++;
    const container = document.getElementById('addressHistoryEntries');

    const addressCard = document.createElement('div');
    addressCard.className = 'card mb-3';
    addressCard.id = `address-${addressHistoryCount}`;
    addressCard.innerHTML = `
        <div class="card-header bg-light d-flex justify-content-between align-items-center">
            <span><i class="bi bi-house"></i> Previous Address #${addressHistoryCount}</span>
            <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeAddressHistory(${addressHistoryCount})">
                <i class="bi bi-trash"></i> Remove
            </button>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Address Line 1 <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="address_history[${addressHistoryCount}][address_line1]" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Address Line 2</label>
                    <input type="text" class="form-control" name="address_history[${addressHistoryCount}][address_line2]">
                </div>
            </div>
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="form-label">City</label>
                    <input type="text" class="form-control" name="address_history[${addressHistoryCount}][city]">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">County</label>
                    <input type="text" class="form-control" name="address_history[${addressHistoryCount}][county]">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Postcode</label>
                    <input type="text" class="form-control" name="address_history[${addressHistoryCount}][postcode]">
                </div>
            </div>
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="form-label">Country</label>
                    <input type="text" class="form-control" name="address_history[${addressHistoryCount}][country]" value="United Kingdom">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Move In Date <span class="text-danger">*</span></label>
                    <input type="date" class="form-control" name="address_history[${addressHistoryCount}][move_in_date]" required>
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Move Out Date <span class="text-danger">*</span></label>
                    <input type="date" class="form-control" name="address_history[${addressHistoryCount}][move_out_date]" required>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 mb-3">
                    <label class="form-label">Notes</label>
                    <textarea class="form-control" name="address_history[${addressHistoryCount}][notes]" rows="2"></textarea>
                </div>
            </div>
        </div>
    `;

    container.appendChild(addressCard);
}

function removeAddressHistory(id) {
    const element = document.getElementById(`address-${id}`);
    if (element) {
        element.remove();
    }
}

// Qualifications Management
let qualificationCount = 0;

function addQualification() {
    qualificationCount++;
    const container = document.getElementById('qualificationsContainer');

    const qualCard = document.createElement('div');
    qualCard.className = 'card mb-3';
    qualCard.id = `qualification-${qualificationCount}`;
    qualCard.innerHTML = `
        <div class="card-header bg-light d-flex justify-content-between align-items-center">
            <span><i class="bi bi-award"></i> Qualification #${qualificationCount}</span>
            <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeQualification(${qualificationCount})">
                <i class="bi bi-trash"></i> Remove
            </button>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Qualification Type <span class="text-danger">*</span></label>
                    <select class="form-select" name="qualifications[${qualificationCount}][qualification_type]" required>
                        <option value="">Select type...</option>
                        <option value="academic">Academic Degree</option>
                        <option value="professional">Professional Qualification</option>
                        <option value="training">Training Course</option>
                        <option value="certification">Certification</option>
                        <option value="license">License/Registration</option>
                        <option value="other">Other</option>
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Qualification Name <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="qualifications[${qualificationCount}][qualification_name]"
                           placeholder="e.g., BSc Computer Science, NVQ Level 3, PRINCE2" required>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Issuing Organization</label>
                    <input type="text" class="form-control" name="qualifications[${qualificationCount}][issuing_organization]"
                           placeholder="e.g., University, Awarding Body, Professional Institute">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Level/Grade</label>
                    <input type="text" class="form-control" name="qualifications[${qualificationCount}][qualification_level]"
                           placeholder="e.g., Bachelor's, Level 3, Advanced">
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Field of Study</label>
                    <input type="text" class="form-control" name="qualifications[${qualificationCount}][field_of_study]"
                           placeholder="e.g., Computer Science, Healthcare, Business">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Certificate/Reference Number</label>
                    <input type="text" class="form-control" name="qualifications[${qualificationCount}][certificate_number]">
                </div>
            </div>
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="form-label">Issue Date</label>
                    <input type="date" class="form-control" name="qualifications[${qualificationCount}][issue_date]">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Expiry Date</label>
                    <input type="date" class="form-control" name="qualifications[${qualificationCount}][expiry_date]">
                    <small class="text-muted">If applicable (e.g., certifications, licenses)</small>
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Grade/Result</label>
                    <input type="text" class="form-control" name="qualifications[${qualificationCount}][grade_result]"
                           placeholder="e.g., First Class, Merit, Pass">
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Country</label>
                    <input type="text" class="form-control" name="qualifications[${qualificationCount}][country]"
                           value="United Kingdom">
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 mb-3">
                    <label class="form-label">Additional Notes</label>
                    <textarea class="form-control" name="qualifications[${qualificationCount}][notes]" rows="2"
                              placeholder="Any additional information about this qualification"></textarea>
                </div>
            </div>
        </div>
    `;

    container.appendChild(qualCard);
}

function removeQualification(id) {
    const element = document.getElementById(`qualification-${id}`);
    if (element) {
        element.remove();
    }
}

// Add at least one qualification field on page load
document.addEventListener('DOMContentLoaded', function() {
    // Auto-add one qualification entry to encourage completion
    setTimeout(() => {
        if (document.getElementById('qualificationsContainer')) {
            addQualification();
        }
    }, 500);
});
