<?php
/**
 * Add Worker Note
 */

session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';
require_once '../../includes/session_manager.php';

require_authentication();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: list.php');
    exit;
}

$worker_id = $_POST['worker_id'] ?? '';
$note_type = $_POST['note_type'] ?? 'general';
$note = trim($_POST['note'] ?? '');
$is_compliance_related = isset($_POST['is_compliance_related']) ? 1 : 0;
$is_confidential = isset($_POST['is_confidential']) ? 1 : 0;

$errors = [];

if (empty($worker_id)) {
    $errors[] = "Worker ID is required";
}

if (empty($note)) {
    $errors[] = "Note content is required";
}

if (!empty($errors)) {
    $_SESSION['error'] = implode(', ', $errors);
    header('Location: view.php?id=' . $worker_id);
    exit;
}

try {
    $stmt = $pdo->prepare("
        INSERT INTO " . DB_PREFIX . "worker_notes
        (worker_id, note_type, note, is_compliance_related, is_confidential, created_by, created_at)
        VALUES (?, ?, ?, ?, ?, ?, NOW())
    ");

    $stmt->execute([
        $worker_id,
        $note_type,
        $note,
        $is_compliance_related,
        $is_confidential,
        $_SESSION['user_id']
    ]);

    $_SESSION['success'] = 'Note added successfully';
    header('Location: view.php?id=' . $worker_id);
    exit;

} catch (PDOException $e) {
    $_SESSION['error'] = 'Failed to add note: ' . $e->getMessage();
    header('Location: view.php?id=' . $worker_id);
    exit;
}
