# Workers Module - UK Home Office Sponsored Workers Management

**Version**: 1.0.0
**Status**: ✅ Complete and Production Ready
**Module ID**: `workers`

---

## Overview

The Workers module is a comprehensive UK Home Office compliant system for managing sponsored workers under the Skilled Worker visa route. It handles all aspects of worker lifecycle management, from Certificate of Sponsorship (CoS) assignment through to termination and Home Office reporting.

---

## UK Home Office Compliance Features

### 1. **Certificate of Sponsorship (CoS) Tracking**
- Complete CoS history for each worker
- CoS number, issue date, start/end dates
- SOC code and salary information
- CoS status tracking (assigned, used, withdrawn, expired)

### 2. **Right to Work (RTW) Checks**
- Initial and follow-up RTW checks
- Document verification tracking
- Share code validation
- Automatic expiry alerts
- RTW check history with audit trail

### 3. **Immigration Status Management**
- Visa type tracking (Skilled Worker, Health & Care, Graduate, etc.)
- BRP/eVisa number recording
- Visa issue and expiry dates
- Immigration status monitoring
- Automatic alerts 30 days before visa expiry

### 4. **Passport & Travel Document Management**
- Passport number and country
- Issue and expiry dates
- Document scanning and storage
- Expiry alerts

### 5. **Home Office Reporting**
- Absence tracking (10+ days reporting requirement)
- Address change reporting
- Job role change reporting
- Salary change reporting
- Employment termination reporting

### 6. **Document Management**
- Passport scans
- Visa/BRP documents
- Certificate of Sponsorship
- RTW check documents
- Qualification certificates
- Bank statements
- Contract documents
- Expiry tracking for all documents

### 7. **Compliance Alerts**
- Visa expiring within 30 days
- Passport expiring soon
- RTW check due
- Missing required documents
- Unreported absences
- Unreported changes

---

## Database Schema

The module uses 7 interconnected tables:

### 1. `scms_sponsored_workers` (Main Table)
Core worker information including:
- Personal details (name, DOB, nationality)
- Contact information (address, phone, email)
- Immigration details (visa type, number, expiry)
- CoS information
- Employment details (job title, salary, hours)
- UK compliance (NI number, tax code)
- Bank details for payroll
- Home Office reporting flags

**Key Fields for UK Home Office**:
- `visa_status` - Type of visa (Skilled Worker, etc.)
- `visa_expiry_date` - Critical for compliance
- `cos_number` - Certificate of Sponsorship reference
- `rtw_check_date` - Last Right to Work check
- `rtw_expiry_date` - When next check is due
- `share_code` - Home Office online RTW verification
- `no_show_count` - Track consecutive absences
- `ho_report_date` - Last report to Home Office

### 2. `scms_worker_documents`
Scanned documents for each worker:
- Document type (passport, visa, BRP, CoS, etc.)
- File storage path
- Issue and expiry dates
- Verification status
- Document number

### 3. `scms_worker_cos_history`
Complete CoS assignment history:
- All CoS numbers issued to worker
- Job title and SOC code on each CoS
- Salary and hours
- CoS usage status

### 4. `scms_worker_contact_history`
Address change tracking:
- Historical addresses
- Home Office reporting status
- Current vs. historical addresses

### 5. `scms_worker_employment_history`
Job role change tracking:
- Previous job titles
- Salary changes
- Department transfers
- Promotion history

### 6. `scms_worker_rtw_checks`
RTW check audit trail:
- All checks performed
- Documents verified
- Share codes used
- Next check due dates

### 7. `scms_worker_notes`
Compliance and HR notes:
- General notes
- Compliance issues
- Home Office contact records
- Disciplinary records

---

## File Structure

```
/modules/workers/
├── module.json              # Module configuration
├── workers.php             # Main entry point (worker list)
├── add.php                 # Add new worker
├── edit.php                # Edit worker details
├── view.php                # View worker profile
├── delete.php              # Delete worker
├── database_schema.sql     # Complete database schema
├── README.md              # This documentation
└── /ajax/                 # Future AJAX endpoints
```

---

## Features Implemented

### Worker List Page (`workers.php`)
✅ Search by name, employee number, passport
✅ Filter by status (active, suspended, terminated)
✅ Filter by visa type
✅ Sort by any column
✅ Visa expiry alerts (color-coded badges)
✅ Statistics dashboard (total, active, expiring, expired)
✅ Export to Excel
✅ Print view
✅ Responsive design with dark mode support

### Worker Profile View (`view.php`)
✅ Complete worker information display
✅ Document list with download links
✅ CoS history timeline
✅ RTW check history
✅ Employment history
✅ Address history
✅ Compliance alerts prominently displayed
✅ Quick actions (edit, print, generate report)

### Add Worker (`add.php`)
✅ Multi-step form for complete worker onboarding
✅ Required field validation
✅ NI number format validation
✅ Passport number validation
✅ Automatic employee number generation (if configured)
✅ Document upload during creation
✅ CoS assignment
✅ Initial RTW check recording

### Edit Worker (`edit.php`)
✅ Update all worker fields
✅ Track changes for Home Office reporting
✅ Address change detection
✅ Salary change detection
✅ Job role change detection
✅ Automatic history recording

---

## UK Home Office Compliance Checklist

This module helps you comply with all UK Home Office sponsor duties:

### Before Employment Starts
- [x] Assign Certificate of Sponsorship
- [x] Record CoS details (number, dates, job, salary)
- [x] Conduct initial Right to Work check
- [x] Verify passport and visa documents
- [x] Obtain copy of BRP/eVisa
- [x] Record worker's UK address

### During Employment
- [x] Track attendance (automatic absence monitoring)
- [x] Monitor visa expiry dates
- [x] Conduct follow-up RTW checks
- [x] Record any job role changes
- [x] Record any salary changes
- [x] Record any address changes
- [x] Report absences over 10 consecutive days

### When Employment Ends
- [x] Record termination date and reason
- [x] Report cessation to Home Office within 10 working days
- [x] Complete exit procedures

### Ongoing Compliance
- [x] Annual RTW checks for indefinite leave workers
- [x] Document expiry monitoring
- [x] Compliance alert system
- [x] Audit trail of all changes
- [x] Reporting dashboard

---

## Module Settings

Configurable via Settings → Modules:

1. **Require NI Number** (default: ON)
   - Make National Insurance number mandatory

2. **Require Right to Work Evidence** (default: ON)
   - Require RTW documents to be uploaded

3. **Alert Days Before Expiry** (default: 30)
   - Days before visa expiry to show alerts

4. **Employee Number Format** (default: Manual)
   - Manual entry
   - Auto numeric (00001, 00002...)
   - Auto alphanumeric (EMP001, EMP002...)

5. **Allow Duplicate Names** (default: ON)
   - Allow multiple workers with same name

---

## Permissions

The module supports role-based access:

- `workers.view` (Level 30+) - View worker list and profiles
- `workers.add` (Level 70+) - Add new workers
- `workers.edit` (Level 70+) - Edit worker details
- `workers.delete` (Level 90+) - Delete workers
- `workers.view_sensitive` (Level 100) - View salary and bank details

---

## Integration Points

### With Other Modules

**Attendance Module**:
- Tracks worker check-in/check-out
- Monitors absences for Home Office reporting
- Links to worker profile

**Holiday Module**:
- Annual leave requests
- Holiday entitlement tracking
- Absence type categorization

**Documents Module**:
- Centralized document repository
- Document expiry alerts
- Secure document storage

**Reports Module**:
- Home Office compliance reports
- Worker demographics
- Visa expiry forecasts
- CoS usage reports

**CoS Module**:
- CoS allocation
- CoS assignment to workers
- CoS usage tracking

---

## Home Office Reporting

The module automatically tracks and flags when you need to report changes to the Home Office:

### Reportable Events (10 Working Days)
1. Worker fails to start work
2. Worker stops working
3. Salary reduced below CoS amount
4. Job role changes significantly
5. Absence over 10 consecutive days
6. Address change
7. Suspected breach of visa conditions

### System Features
- Flags unreported events
- Tracks report submission dates
- Compliance dashboard showing pending reports
- Audit log of all Home Office communications

---

## Technical Details

**Language**: PHP 7.4+
**Database**: MySQL/MariaDB with InnoDB
**Frontend**: Bootstrap 5, modern CSS with dark mode
**File Upload**: Secure document storage with virus scanning
**Security**: CSRF protection, XSS prevention, SQL injection protection
**Audit**: Complete audit trail of all actions

---

## Installation

1. **Module is Auto-Discovered**
   - Place in `/modules/workers/` directory
   - ModuleManager will detect it automatically

2. **Activate Module**
   - Go to Settings → Modules
   - Click "Scan for Modules"
   - Click "Activate" on Workers module

3. **Database Schema**
   - Schema is in `database_schema.sql`
   - Can be imported manually or via installer
   - All tables use `scms_` prefix

4. **Configure Settings**
   - Settings → Modules → Workers → Settings
   - Adjust compliance requirements

5. **Set Permissions**
   - Users → Role Management
   - Assign workers permissions to roles

---

## Usage Guide

### Adding a New Sponsored Worker

1. Navigate to **Sponsored Workers**
2. Click **Add New Worker**
3. Complete the multi-step form:
   - **Step 1**: Personal Details
   - **Step 2**: Immigration & Visa
   - **Step 3**: Certificate of Sponsorship
   - **Step 4**: Employment Details
   - **Step 5**: Right to Work Check
   - **Step 6**: Documents Upload
4. Review and submit

### Conducting a Right to Work Check

1. Go to worker profile
2. Click **RTW Check** tab
3. Click **New RTW Check**
4. Enter:
   - Documents seen
   - Share code (if using online service)
   - Check outcome
5. Upload copies of documents
6. System sets next check due date automatically

### Monitoring Visa Expiries

1. Dashboard shows **Expiring Soon** count
2. Click to see list of workers
3. System shows:
   - Red badge: Expired
   - Orange badge: Expiring in 30 days
   - Green badge: Valid
4. Click worker to take action

### Reporting to Home Office

1. System flags events requiring report
2. "Requires Attention" badge on worker
3. View worker profile for details
4. Record report submission:
   - Add note with type "HO Contact"
   - Update `ho_report_date` field
   - Clear compliance alert

---

## Future Enhancements

Planned for v1.1:
- [ ] Bulk import from Excel
- [ ] Direct Home Office SMS integration
- [ ] Automated email reminders for expiring documents
- [ ] Mobile app for workers
- [ ] Biometric integration
- [ ] AI-powered compliance assistant

---

## Support & Documentation

- Full API documentation: `/docs/api/workers/`
- Video tutorials: `/docs/videos/`
- Home Office guidance: [gov.uk/sponsor-migrant-worker](https://www.gov.uk/sponsor-migrant-worker)

---

## Credits

**Developed by**: SCMS Team
**Home Office Guidance Compliance**: Based on UK Visas and Immigration sponsor guidance (October 2025)
**Legal Notice**: This system assists with compliance but does not replace professional immigration advice.

---

**Last Updated**: October 9, 2025
**Module Status**: ✅ Production Ready
**Compliance Review**: Completed
