-- System alerts table for RTW module
CREATE TABLE IF NOT EXISTS `scms_rtw_alerts` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `alert_type` enum('expiry_warning','expired','share_code_pending','reminder_sent','check_overdue') NOT NULL,
    `severity` enum('info','warning','danger','success') DEFAULT 'info',
    `worker_id` int(11) DEFAULT NULL,
    `submission_id` int(11) DEFAULT NULL,
    `title` varchar(255) NOT NULL,
    `message` text NOT NULL,
    `action_url` varchar(255) DEFAULT NULL,
    `status` enum('active','acknowledged','resolved','dismissed') DEFAULT 'active',
    `created_at` datetime NOT NULL,
    `created_by` int(11) DEFAULT NULL,
    `acknowledged_at` datetime DEFAULT NULL,
    `acknowledged_by` int(11) DEFAULT NULL,
    `resolved_at` datetime DEFAULT NULL,
    `resolved_by` int(11) DEFAULT NULL,
    `auto_resolve_date` date DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `worker_id` (`worker_id`),
    KEY `status` (`status`),
    KEY `alert_type` (`alert_type`),
    KEY `created_at` (`created_at`),
    KEY `severity` (`severity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- System activity log for tracking all RTW actions
CREATE TABLE IF NOT EXISTS `scms_rtw_activity_log` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `activity_type` varchar(50) NOT NULL,
    `activity_description` text NOT NULL,
    `worker_id` int(11) DEFAULT NULL,
    `submission_id` int(11) DEFAULT NULL,
    `check_id` int(11) DEFAULT NULL,
    `user_id` int(11) DEFAULT NULL,
    `ip_address` varchar(45) DEFAULT NULL,
    `created_at` datetime NOT NULL,
    PRIMARY KEY (`id`),
    KEY `worker_id` (`worker_id`),
    KEY `user_id` (`user_id`),
    KEY `created_at` (`created_at`),
    KEY `activity_type` (`activity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Email queue for better tracking
CREATE TABLE IF NOT EXISTS `scms_email_queue` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `module` varchar(50) DEFAULT 'rtw',
    `to_email` varchar(255) NOT NULL,
    `to_name` varchar(255) DEFAULT NULL,
    `subject` varchar(255) NOT NULL,
    `body` text NOT NULL,
    `priority` int(1) DEFAULT 5,
    `status` enum('pending','sending','sent','failed') DEFAULT 'pending',
    `attempts` int(11) DEFAULT 0,
    `scheduled_at` datetime DEFAULT NULL,
    `sent_at` datetime DEFAULT NULL,
    `error_message` text,
    `created_at` datetime NOT NULL,
    PRIMARY KEY (`id`),
    KEY `status` (`status`),
    KEY `priority` (`priority`),
    KEY `scheduled_at` (`scheduled_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;