-- Complete RTW Module Database Installation
-- Run this file to create all necessary tables for RTW module

-- 1. Share code submissions table
CREATE TABLE IF NOT EXISTS `scms_rtw_share_code_submissions` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `worker_id` int(11) NOT NULL,
    `share_code` varchar(20) NOT NULL,
    `document_type` varchar(50) DEFAULT 'share_code',
    `document_path` varchar(255) DEFAULT NULL,
    `additional_info` text,
    `submission_status` enum('pending','verified','rejected','expired') DEFAULT 'pending',
    `verified_by` int(11) DEFAULT NULL,
    `verified_at` datetime DEFAULT NULL,
    `verification_notes` text,
    `submitted_by` int(11) DEFAULT NULL,
    `submitted_at` datetime NOT NULL,
    `expires_at` date DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `worker_id` (`worker_id`),
    KEY `submission_status` (`submission_status`),
    KEY `submitted_at` (`submitted_at`),
    KEY `idx_worker_status` (`worker_id`, `submission_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 2. Share code reminder log
CREATE TABLE IF NOT EXISTS `scms_rtw_reminder_log` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `worker_id` int(11) NOT NULL,
    `reminder_type` varchar(50) NOT NULL,
    `sent_at` datetime NOT NULL,
    `sent_to` varchar(255) NOT NULL,
    `email_status` varchar(20) DEFAULT 'sent',
    `next_reminder_date` date DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `worker_id` (`worker_id`),
    KEY `sent_at` (`sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 3. System alerts table for RTW module
CREATE TABLE IF NOT EXISTS `scms_rtw_alerts` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `alert_type` enum('expiry_warning','expired','share_code_pending','reminder_sent','check_overdue') NOT NULL,
    `severity` enum('info','warning','danger','success') DEFAULT 'info',
    `worker_id` int(11) DEFAULT NULL,
    `submission_id` int(11) DEFAULT NULL,
    `title` varchar(255) NOT NULL,
    `message` text NOT NULL,
    `action_url` varchar(255) DEFAULT NULL,
    `status` enum('active','acknowledged','resolved','dismissed') DEFAULT 'active',
    `created_at` datetime NOT NULL,
    `created_by` int(11) DEFAULT NULL,
    `acknowledged_at` datetime DEFAULT NULL,
    `acknowledged_by` int(11) DEFAULT NULL,
    `resolved_at` datetime DEFAULT NULL,
    `resolved_by` int(11) DEFAULT NULL,
    `auto_resolve_date` date DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `worker_id` (`worker_id`),
    KEY `status` (`status`),
    KEY `alert_type` (`alert_type`),
    KEY `created_at` (`created_at`),
    KEY `severity` (`severity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 4. System activity log for tracking all RTW actions
CREATE TABLE IF NOT EXISTS `scms_rtw_activity_log` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `activity_type` varchar(50) NOT NULL,
    `activity_description` text NOT NULL,
    `worker_id` int(11) DEFAULT NULL,
    `submission_id` int(11) DEFAULT NULL,
    `check_id` int(11) DEFAULT NULL,
    `user_id` int(11) DEFAULT NULL,
    `ip_address` varchar(45) DEFAULT NULL,
    `created_at` datetime NOT NULL,
    PRIMARY KEY (`id`),
    KEY `worker_id` (`worker_id`),
    KEY `user_id` (`user_id`),
    KEY `created_at` (`created_at`),
    KEY `activity_type` (`activity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 5. Email queue for better tracking
CREATE TABLE IF NOT EXISTS `scms_email_queue` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `module` varchar(50) DEFAULT 'rtw',
    `to_email` varchar(255) NOT NULL,
    `to_name` varchar(255) DEFAULT NULL,
    `subject` varchar(255) NOT NULL,
    `body` text NOT NULL,
    `priority` int(1) DEFAULT 5,
    `status` enum('pending','sending','sent','failed') DEFAULT 'pending',
    `attempts` int(11) DEFAULT 0,
    `scheduled_at` datetime DEFAULT NULL,
    `sent_at` datetime DEFAULT NULL,
    `error_message` text,
    `created_at` datetime NOT NULL,
    PRIMARY KEY (`id`),
    KEY `status` (`status`),
    KEY `priority` (`priority`),
    KEY `scheduled_at` (`scheduled_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 6. RTW document types (already created but including for completeness)
CREATE TABLE IF NOT EXISTS `scms_rtw_document_types` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `document_name` varchar(100) NOT NULL,
    `list_type` varchar(50) DEFAULT NULL,
    `validity_period` int(11) DEFAULT NULL,
    `requires_followup` tinyint(1) DEFAULT 0,
    `is_active` tinyint(1) DEFAULT 1,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 7. RTW statutory excuse periods (already created but including for completeness)
CREATE TABLE IF NOT EXISTS `scms_rtw_statutory_excuse` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `document_type` varchar(100) NOT NULL,
    `excuse_period` int(11) DEFAULT NULL,
    `description` text,
    `is_active` tinyint(1) DEFAULT 1,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 8. RTW compliance reports (already created but including for completeness)
CREATE TABLE IF NOT EXISTS `scms_rtw_compliance_reports` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `report_date` datetime NOT NULL,
    `total_workers` int(11) DEFAULT 0,
    `compliant` int(11) DEFAULT 0,
    `non_compliant` int(11) DEFAULT 0,
    `expiring_soon` int(11) DEFAULT 0,
    `generated_by` int(11) DEFAULT NULL,
    `report_data` text,
    PRIMARY KEY (`id`),
    KEY `report_date` (`report_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 9. System logs table (generic, used by cron)
CREATE TABLE IF NOT EXISTS `scms_system_logs` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `log_type` varchar(50) NOT NULL,
    `log_message` text NOT NULL,
    `log_data` text,
    `created_at` datetime NOT NULL,
    `created_by` int(11) DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `log_type` (`log_type`),
    KEY `created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert default document types if not exists
INSERT IGNORE INTO `scms_rtw_document_types` (`document_name`, `list_type`, `validity_period`, `requires_followup`) VALUES
('British Passport', 'List A', NULL, 0),
('Irish Passport', 'List A', NULL, 0),
('EEA/Swiss Passport', 'List A', NULL, 0),
('UK Birth Certificate + NI Number', 'List A', NULL, 0),
('Biometric Residence Permit', 'List B', 365, 1),
('Share Code', 'List B', 365, 1),
('Visa', 'List B', 365, 1),
('Immigration Status Document', 'List B', 365, 1);

-- Insert default statutory excuse periods
INSERT IGNORE INTO `scms_rtw_statutory_excuse` (`document_type`, `excuse_period`, `description`) VALUES
('List A Documents', NULL, 'Provides continuous statutory excuse'),
('List B Documents', 365, 'Provides time-limited statutory excuse - must recheck'),
('Share Code', 365, 'Online check provides 12 month statutory excuse'),
('Student Visa', 180, 'Check every 6 months or at visa expiry');

-- Add sample alert for testing (optional - comment out in production)
-- INSERT INTO `scms_rtw_alerts` (`alert_type`, `severity`, `title`, `message`, `action_url`, `status`, `created_at`)
-- VALUES ('info', 'info', 'RTW Module Installed', 'RTW module has been successfully installed with all features', 'list.php', 'active', NOW());