-- RTW Module Installation SQL
-- UK Home Office Compliant Right to Work System

-- Main RTW checks table
CREATE TABLE IF NOT EXISTS `{{DB_PREFIX}}worker_rtw_checks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `worker_id` int(11) NOT NULL,
  `check_date` date NOT NULL,
  `check_type` enum('initial','follow_up','annual','retrospective') NOT NULL,
  `check_method` enum('manual','online','adjusted') DEFAULT 'manual',
  `document_type` varchar(100) DEFAULT NULL,
  `document_number` varchar(100) DEFAULT NULL,
  `document_expiry` date DEFAULT NULL,
  `documents_seen` text NOT NULL,
  `share_code_used` varchar(20) DEFAULT NULL,
  `online_check` tinyint(1) DEFAULT 0,
  `outcome` enum('pass','fail','refer','pending') NOT NULL,
  `next_check_due` date DEFAULT NULL,
  `checked_by` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_worker` (`worker_id`),
  KEY `idx_next_check` (`next_check_due`),
  KEY `idx_outcome` (`outcome`),
  KEY `idx_check_date` (`check_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- RTW document types reference table
CREATE TABLE IF NOT EXISTS `{{DB_PREFIX}}rtw_document_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `list_type` enum('list_a','list_b') NOT NULL,
  `group_number` varchar(10) DEFAULT NULL,
  `document_name` varchar(255) NOT NULL,
  `document_code` varchar(50) NOT NULL,
  `requires_expiry` tinyint(1) DEFAULT 0,
  `combination_required` tinyint(1) DEFAULT 0,
  `combination_with` varchar(255) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `active` tinyint(1) DEFAULT 1,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_document_code` (`document_code`),
  KEY `idx_list_type` (`list_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- RTW documents evidence storage
CREATE TABLE IF NOT EXISTS `{{DB_PREFIX}}rtw_documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `check_id` int(11) DEFAULT NULL,
  `worker_id` int(11) NOT NULL,
  `document_type_id` int(11) DEFAULT NULL,
  `document_name` varchar(255) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_path` varchar(500) NOT NULL,
  `file_size` int(11) DEFAULT NULL,
  `mime_type` varchar(100) DEFAULT NULL,
  `page_number` int(11) DEFAULT 1,
  `uploaded_by` int(11) NOT NULL,
  `uploaded_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `verified` tinyint(1) DEFAULT 0,
  `verified_by` int(11) DEFAULT NULL,
  `verified_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_check` (`check_id`),
  KEY `idx_worker` (`worker_id`),
  KEY `idx_document_type` (`document_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- RTW share codes tracking
CREATE TABLE IF NOT EXISTS `{{DB_PREFIX}}rtw_share_codes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `worker_id` int(11) NOT NULL,
  `share_code` varchar(20) NOT NULL,
  `date_provided` date NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `check_performed` tinyint(1) DEFAULT 0,
  `check_date` datetime DEFAULT NULL,
  `check_result` enum('valid','invalid','expired','pending') DEFAULT 'pending',
  `profile_url` varchar(500) DEFAULT NULL,
  `checked_by` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_worker` (`worker_id`),
  KEY `idx_share_code` (`share_code`),
  KEY `idx_expiry` (`expiry_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- RTW check reminders
CREATE TABLE IF NOT EXISTS `{{DB_PREFIX}}rtw_reminders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `worker_id` int(11) NOT NULL,
  `check_id` int(11) DEFAULT NULL,
  `reminder_type` enum('expiry','annual','follow_up','missing') NOT NULL,
  `reminder_date` date NOT NULL,
  `days_before` int(11) DEFAULT 30,
  `sent` tinyint(1) DEFAULT 0,
  `sent_date` datetime DEFAULT NULL,
  `sent_to` varchar(255) DEFAULT NULL,
  `acknowledged` tinyint(1) DEFAULT 0,
  `acknowledged_by` int(11) DEFAULT NULL,
  `acknowledged_date` datetime DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_worker` (`worker_id`),
  KEY `idx_reminder_date` (`reminder_date`),
  KEY `idx_sent` (`sent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- RTW audit trail
CREATE TABLE IF NOT EXISTS `{{DB_PREFIX}}rtw_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `worker_id` int(11) NOT NULL,
  `check_id` int(11) DEFAULT NULL,
  `action` varchar(100) NOT NULL,
  `details` text DEFAULT NULL,
  `performed_by` int(11) NOT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_worker` (`worker_id`),
  KEY `idx_check` (`check_id`),
  KEY `idx_action` (`action`),
  KEY `idx_created` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- RTW statutory excuse records
CREATE TABLE IF NOT EXISTS `{{DB_PREFIX}}rtw_statutory_excuse` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `worker_id` int(11) NOT NULL,
  `check_id` int(11) NOT NULL,
  `established_date` date NOT NULL,
  `valid_from` date NOT NULL,
  `valid_until` date DEFAULT NULL,
  `excuse_type` enum('list_a','list_b_time_limited','online_check') NOT NULL,
  `evidence_retained` tinyint(1) DEFAULT 1,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_worker` (`worker_id`),
  KEY `idx_check` (`check_id`),
  KEY `idx_valid_until` (`valid_until`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- RTW compliance reports
CREATE TABLE IF NOT EXISTS `{{DB_PREFIX}}rtw_compliance_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_date` date NOT NULL,
  `total_workers` int(11) DEFAULT 0,
  `checks_completed` int(11) DEFAULT 0,
  `checks_pending` int(11) DEFAULT 0,
  `checks_overdue` int(11) DEFAULT 0,
  `compliance_rate` decimal(5,2) DEFAULT NULL,
  `generated_by` int(11) NOT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_report_date` (`report_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert standard RTW document types
INSERT INTO `{{DB_PREFIX}}rtw_document_types` (`list_type`, `group_number`, `document_name`, `document_code`, `requires_expiry`, `combination_required`, `combination_with`, `notes`) VALUES
-- List A Group 1
('list_a', '1', 'UK Passport', 'UK_PASSPORT', 0, 0, NULL, 'Current or expired UK passport'),
('list_a', '1', 'Irish Passport', 'IRISH_PASSPORT', 0, 0, NULL, 'Current or expired Irish passport'),
('list_a', '1', 'EU/EEA/Swiss Passport with Status', 'EU_PASSPORT_STATUS', 0, 0, NULL, 'With evidence of settled or pre-settled status'),

-- List A Group 2
('list_a', '2', 'UK Birth Certificate + NI Document', 'UK_BIRTH_NI', 0, 1, 'NI_DOC', 'UK birth certificate with NI number document'),
('list_a', '2', 'UK Adoption Certificate + NI Document', 'UK_ADOPTION_NI', 0, 1, 'NI_DOC', 'UK adoption certificate with NI number document'),

-- List B Group 1
('list_b', '1', 'Current Passport with Visa', 'PASSPORT_VISA', 1, 0, NULL, 'Valid passport with UK visa'),
('list_b', '1', 'Biometric Residence Permit (BRP)', 'BRP', 1, 0, NULL, 'Current Biometric Residence Permit'),
('list_b', '1', 'Frontier Worker Permit', 'FWP', 1, 0, NULL, 'Current Frontier Worker Permit'),

-- List B Group 2
('list_b', '2', 'Birth Certificate (non-UK)', 'BIRTH_CERT_NON_UK', 0, 1, 'HO_LETTER', 'With Home Office letter'),
('list_b', '2', 'Positive Verification Notice', 'PVN', 1, 0, NULL, 'Employer Checking Service positive verification'),
('list_b', '2', 'Certificate of Application', 'COA', 1, 0, NULL, 'Less than 6 months old'),

-- Digital/Online checks
('list_b', '3', 'Online Right to Work Check', 'ONLINE_CHECK', 1, 0, NULL, 'Via GOV.UK online service with share code'),
('list_b', '3', 'Home Office Online Check', 'HO_ONLINE', 1, 0, NULL, 'Home Office online verification');