<?php
/**
 * RTW Module Installation Script
 */

function install_rtw($pdo) {
    try {
        // Create upload directory for RTW documents
        $upload_dir = dirname(dirname(__DIR__)) . '/uploads/rtw';
        if (!file_exists($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }

        // Add RTW fields to sponsored_workers table if they don't exist
        $stmt = $pdo->query("DESCRIBE " . DB_PREFIX . "sponsored_workers");
        $existing_fields = [];
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $existing_fields[] = $row['Field'];
        }

        // Add RTW-specific fields to workers table
        $fields_to_add = [
            'rtw_status' => "ALTER TABLE " . DB_PREFIX . "sponsored_workers ADD COLUMN rtw_status ENUM('compliant','expired','missing','pending') DEFAULT 'pending'",
            'rtw_last_check' => "ALTER TABLE " . DB_PREFIX . "sponsored_workers ADD COLUMN rtw_last_check date DEFAULT NULL",
            'rtw_next_check' => "ALTER TABLE " . DB_PREFIX . "sponsored_workers ADD COLUMN rtw_next_check date DEFAULT NULL",
            'rtw_documents_count' => "ALTER TABLE " . DB_PREFIX . "sponsored_workers ADD COLUMN rtw_documents_count int(11) DEFAULT 0"
        ];

        foreach ($fields_to_add as $field => $sql) {
            if (!in_array($field, $existing_fields)) {
                try {
                    $pdo->exec($sql);
                    error_log("RTW Install: Added field $field to sponsored_workers table");
                } catch (PDOException $e) {
                    error_log("RTW Install: Could not add field $field: " . $e->getMessage());
                }
            }
        }

        // Create indexes for better performance
        $indexes = [
            "CREATE INDEX idx_rtw_status ON " . DB_PREFIX . "sponsored_workers(rtw_status)",
            "CREATE INDEX idx_rtw_next_check ON " . DB_PREFIX . "sponsored_workers(rtw_next_check)"
        ];

        foreach ($indexes as $index) {
            try {
                $pdo->exec($index);
            } catch (PDOException $e) {
                // Index might already exist, ignore error
            }
        }

        // Initialize RTW status for existing workers
        $pdo->exec("
            UPDATE " . DB_PREFIX . "sponsored_workers
            SET rtw_status = 'pending'
            WHERE rtw_status IS NULL
        ");

        // Log installation
        error_log("RTW Module installed successfully");
        return true;

    } catch (Exception $e) {
        error_log("RTW Module installation failed: " . $e->getMessage());
        return false;
    }
}
?>