<?php
/**
 * RTW Audit Trail Functions
 */

function log_rtw_action($pdo, $action, $check_id = null, $worker_id = null, $details = '') {
    try {
        $sql = "INSERT INTO " . DB_PREFIX . "rtw_audit 
                (action, check_id, worker_id, user_id, details, ip_address, created_at)
                VALUES (?, ?, ?, ?, ?, ?, NOW())";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $action,
            $check_id,
            $worker_id,
            $_SESSION['user_id'] ?? null,
            $details,
            $_SERVER['REMOTE_ADDR'] ?? null
        ]);
        
        return true;
    } catch (PDOException $e) {
        error_log("RTW Audit Error: " . $e->getMessage());
        return false;
    }
}
