<?php
/**
 * RTW Module Email Templates
 * All email templates specific to the RTW module
 */

class RTWEmailTemplates {

    /**
     * RTW Check Expiry Alert Email
     */
    public static function getExpiryAlertEmail($worker_name, $days_until_expiry, $document_type, $check_date) {
        $urgency = '';
        $color = '#17a2b8'; // info blue

        if ($days_until_expiry < 0) {
            $message = "Your Right to Work check has <strong style='color: #dc3545;'>EXPIRED</strong>.";
            $action = "Please contact HR immediately to update your documentation.";
            $urgency = 'URGENT: ';
            $color = '#dc3545'; // danger red
        } elseif ($days_until_expiry == 0) {
            $message = "Your Right to Work check <strong style='color: #dc3545;'>expires TODAY</strong>.";
            $action = "Please submit your updated documents immediately.";
            $urgency = 'URGENT: ';
            $color = '#dc3545'; // danger red
        } elseif ($days_until_expiry <= 7) {
            $message = "Your Right to Work check will expire in <strong style='color: #ffc107;'>$days_until_expiry days</strong>.";
            $action = "Please prepare your documents for renewal as soon as possible.";
            $urgency = 'IMPORTANT: ';
            $color = '#ffc107'; // warning yellow
        } elseif ($days_until_expiry <= 30) {
            $message = "Your Right to Work check will expire in <strong>$days_until_expiry days</strong>.";
            $action = "Please start preparing your documents for renewal.";
            $color = '#28a745'; // success green
        } else {
            $message = "Your Right to Work check will expire in <strong>$days_until_expiry days</strong>.";
            $action = "Please ensure your documents are ready for renewal when required.";
        }

        $subject = $urgency . "RTW Check Expiry Alert";

        $body = "
        <h3>Dear $worker_name,</h3>

        <p>$message</p>

        <div style='background-color: #f8f9fa; padding: 20px; border-left: 5px solid $color; margin: 20px 0;'>
            <p style='margin: 0; font-weight: bold; font-size: 16px;'>$action</p>
        </div>

        <div style='background-color: #ffffff; border: 1px solid #dee2e6; padding: 15px; margin: 20px 0;'>
            <h4 style='margin-top: 0; color: #495057;'>Current Check Details:</h4>
            <ul style='margin: 10px 0;'>
                <li><strong>Document Type:</strong> $document_type</li>
                <li><strong>Last Check Date:</strong> " . date('d/m/Y', strtotime($check_date)) . "</li>
                <li><strong>Days Until Expiry:</strong> " . abs($days_until_expiry) . " days " .
                ($days_until_expiry < 0 ? '(overdue)' : 'remaining') . "</li>
            </ul>
        </div>

        <h4>What you need to do:</h4>
        <ol>
            <li>Gather your updated Right to Work documents</li>
            <li>Contact your HR department to schedule a verification appointment</li>
            <li>Bring original documents for verification</li>
            <li>Complete the verification process before expiry</li>
        </ol>

        <div style='background-color: #e7f3ff; padding: 15px; margin: 20px 0; border-radius: 5px;'>
            <p style='margin: 0;'><strong>Need Help?</strong><br>
            If you have any questions about your Right to Work status or required documents,
            please contact the HR team immediately.</p>
        </div>

        <p style='color: #6c757d; font-size: 14px; margin-top: 30px;'>
            This is an automated reminder from the Staff Compliance Management System.
            Please do not reply to this email.
        </p>";

        return ['subject' => $subject, 'body' => $body];
    }

    /**
     * RTW Check Completed Confirmation Email
     */
    public static function getCheckConfirmationEmail($worker_name, $check_date, $outcome, $next_check_date, $documents_seen) {
        $outcome_message = $outcome == 'pass'
            ? "<span style='color: #28a745; font-weight: bold;'>PASSED</span>"
            : "<span style='color: #dc3545; font-weight: bold;'>REQUIRES ATTENTION</span>";

        $subject = "RTW Check Completed - " . ucfirst($outcome);

        $body = "
        <h3>Dear $worker_name,</h3>

        <p>This email confirms that your Right to Work check has been completed.</p>

        <div style='background-color: #ffffff; border: 2px solid " . ($outcome == 'pass' ? '#28a745' : '#dc3545') . ";
                    padding: 20px; margin: 20px 0; border-radius: 5px;'>
            <h4 style='margin-top: 0;'>Check Details:</h4>
            <table style='width: 100%; border-collapse: collapse;'>
                <tr>
                    <td style='padding: 5px 0;'><strong>Check Date:</strong></td>
                    <td style='padding: 5px 0;'>" . date('d/m/Y', strtotime($check_date)) . "</td>
                </tr>
                <tr>
                    <td style='padding: 5px 0;'><strong>Check Result:</strong></td>
                    <td style='padding: 5px 0;'>$outcome_message</td>
                </tr>";

        if ($next_check_date) {
            $body .= "
                <tr>
                    <td style='padding: 5px 0;'><strong>Next Check Due:</strong></td>
                    <td style='padding: 5px 0;'>" . date('d/m/Y', strtotime($next_check_date)) . "</td>
                </tr>";
        }

        $body .= "
            </table>
        </div>

        <div style='background-color: #f8f9fa; padding: 15px; margin: 20px 0;'>
            <h4>Documents Verified:</h4>
            <p>" . nl2br(htmlspecialchars($documents_seen)) . "</p>
        </div>";

        if ($outcome == 'pass') {
            $body .= "
            <div style='background-color: #d4edda; border: 1px solid #c3e6cb; padding: 15px; margin: 20px 0; border-radius: 5px;'>
                <p style='margin: 0;'><strong>✓ Your Right to Work status has been confirmed.</strong><br>
                A copy of this verification has been filed in your employment records.</p>
            </div>";
        } else {
            $body .= "
            <div style='background-color: #f8d7da; border: 1px solid #f5c6cb; padding: 15px; margin: 20px 0; border-radius: 5px;'>
                <p style='margin: 0;'><strong>⚠ Additional action required.</strong><br>
                Please contact the HR department immediately to resolve any issues with your Right to Work status.</p>
            </div>";
        }

        $body .= "
        <p>If you have any questions about this check, please contact the HR department.</p>

        <p style='color: #6c757d; font-size: 14px; margin-top: 30px;'>
            This is an automated confirmation from the Staff Compliance Management System.
            Please keep this email for your records.
        </p>";

        return ['subject' => $subject, 'body' => $body];
    }

    /**
     * HR Notification for Expiring RTW Checks
     */
    public static function getHRNotificationEmail($expiring_checks, $overdue_checks) {
        $total_alerts = count($expiring_checks) + count($overdue_checks);

        $subject = "RTW Alert: $total_alerts Checks Require Attention";

        $body = "
        <h3>RTW Compliance Alert</h3>

        <p>This is an automated notification of Right to Work checks requiring attention.</p>";

        if (count($overdue_checks) > 0) {
            $body .= "
            <div style='background-color: #f8d7da; border: 1px solid #dc3545; padding: 15px; margin: 20px 0; border-radius: 5px;'>
                <h4 style='color: #dc3545; margin-top: 0;'>⚠ OVERDUE CHECKS (" . count($overdue_checks) . ")</h4>
                <table style='width: 100%; border-collapse: collapse;'>
                    <thead>
                        <tr style='background-color: #dc3545; color: white;'>
                            <th style='padding: 8px; text-align: left;'>Employee</th>
                            <th style='padding: 8px; text-align: left;'>Days Overdue</th>
                            <th style='padding: 8px; text-align: left;'>Last Check</th>
                        </tr>
                    </thead>
                    <tbody>";

            foreach ($overdue_checks as $check) {
                $body .= "
                        <tr style='border-bottom: 1px solid #dee2e6;'>
                            <td style='padding: 8px;'>{$check['worker_name']}</td>
                            <td style='padding: 8px;'>{$check['days_overdue']} days</td>
                            <td style='padding: 8px;'>" . date('d/m/Y', strtotime($check['last_check'])) . "</td>
                        </tr>";
            }

            $body .= "
                    </tbody>
                </table>
            </div>";
        }

        if (count($expiring_checks) > 0) {
            $body .= "
            <div style='background-color: #fff3cd; border: 1px solid #ffc107; padding: 15px; margin: 20px 0; border-radius: 5px;'>
                <h4 style='color: #856404; margin-top: 0;'>⏰ EXPIRING SOON (" . count($expiring_checks) . ")</h4>
                <table style='width: 100%; border-collapse: collapse;'>
                    <thead>
                        <tr style='background-color: #ffc107; color: #212529;'>
                            <th style='padding: 8px; text-align: left;'>Employee</th>
                            <th style='padding: 8px; text-align: left;'>Days Until Expiry</th>
                            <th style='padding: 8px; text-align: left;'>Expiry Date</th>
                        </tr>
                    </thead>
                    <tbody>";

            foreach ($expiring_checks as $check) {
                $body .= "
                        <tr style='border-bottom: 1px solid #dee2e6;'>
                            <td style='padding: 8px;'>{$check['worker_name']}</td>
                            <td style='padding: 8px;'>{$check['days_until']} days</td>
                            <td style='padding: 8px;'>" . date('d/m/Y', strtotime($check['expiry_date'])) . "</td>
                        </tr>";
            }

            $body .= "
                    </tbody>
                </table>
            </div>";
        }

        $body .= "
        <div style='background-color: #e7f3ff; padding: 15px; margin: 20px 0; border-radius: 5px;'>
            <h4>Recommended Actions:</h4>
            <ul>
                <li>Contact affected employees immediately</li>
                <li>Schedule RTW verification appointments</li>
                <li>Ensure all documentation is prepared</li>
                <li>Update records once checks are complete</li>
            </ul>
        </div>

        <p>Access the RTW module to view full details and manage these checks.</p>

        <p style='color: #6c757d; font-size: 14px; margin-top: 30px;'>
            This is an automated alert from the Staff Compliance Management System.
            Generated on " . date('d/m/Y H:i:s') . "
        </p>";

        return ['subject' => $subject, 'body' => $body];
    }
}