<?php
/**
 * Delete RTW Check
 */

session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';
require_once '../../includes/session_manager.php';
require_authentication();

$check_id = $_GET['id'] ?? 0;

if (!$check_id) {
    $_SESSION['error'] = 'Invalid check ID';
    header('Location: list.php');
    exit;
}

try {
    // Get check details for audit
    $stmt = $pdo->prepare("SELECT * FROM " . DB_PREFIX . "worker_rtw_checks WHERE id = ?");
    $stmt->execute([$check_id]);
    $check = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$check) {
        $_SESSION['error'] = 'RTW check not found';
        header('Location: list.php');
        exit;
    }

    // Log deletion in audit trail
    $audit_sql = "INSERT INTO " . DB_PREFIX . "rtw_audit
                  (action, check_id, worker_id, user_id, details, ip_address, created_at)
                  VALUES ('delete', ?, ?, ?, ?, ?, NOW())";

    $audit_stmt = $pdo->prepare($audit_sql);
    $audit_stmt->execute([
        $check_id,
        $check['worker_id'],
        $_SESSION['user_id'] ?? null,
        'Deleted RTW check from ' . $check['check_date'],
        $_SERVER['REMOTE_ADDR'] ?? null
    ]);

    // Delete related documents first
    $stmt = $pdo->prepare("DELETE FROM " . DB_PREFIX . "rtw_documents WHERE check_id = ?");
    $stmt->execute([$check_id]);

    // Delete the check
    $stmt = $pdo->prepare("DELETE FROM " . DB_PREFIX . "worker_rtw_checks WHERE id = ?");
    $stmt->execute([$check_id]);

    $_SESSION['success'] = 'RTW check deleted successfully';

} catch (PDOException $e) {
    $_SESSION['error'] = 'Error deleting RTW check: ' . $e->getMessage();
}

// Redirect back to list
header('Location: list.php');
exit;