<?php
/**
 * Create RTW Tables
 * Run this once to set up the RTW database tables
 */

require_once '../../config/database.php';

echo "<h2>Creating RTW Module Tables...</h2>";

$tables_created = 0;
$errors = [];

// Table creation SQLs
$tables = [
    "worker_rtw_checks" => "
        CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "worker_rtw_checks` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `worker_id` int(11) NOT NULL,
            `check_date` date NOT NULL,
            `check_type` enum('initial','follow_up','annual','retrospective') NOT NULL,
            `check_method` enum('manual','online','adjusted') DEFAULT 'manual',
            `document_type` varchar(100) DEFAULT NULL,
            `document_number` varchar(100) DEFAULT NULL,
            `document_expiry` date DEFAULT NULL,
            `documents_seen` text NOT NULL,
            `share_code_used` varchar(20) DEFAULT NULL,
            `online_check` tinyint(1) DEFAULT 0,
            `outcome` enum('pass','fail','refer','pending') NOT NULL,
            `next_check_due` date DEFAULT NULL,
            `checked_by` int(11) DEFAULT NULL,
            `notes` text DEFAULT NULL,
            `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            KEY `idx_worker` (`worker_id`),
            KEY `idx_next_check` (`next_check_due`),
            KEY `idx_outcome` (`outcome`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ",

    "rtw_documents" => "
        CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "rtw_documents` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `check_id` int(11) DEFAULT NULL,
            `worker_id` int(11) NOT NULL,
            `document_type_id` int(11) DEFAULT NULL,
            `document_name` varchar(255) NOT NULL,
            `file_name` varchar(255) NOT NULL,
            `file_path` varchar(500) NOT NULL,
            `file_size` int(11) DEFAULT NULL,
            `mime_type` varchar(100) DEFAULT NULL,
            `page_number` int(11) DEFAULT 1,
            `uploaded_by` int(11) NOT NULL,
            `uploaded_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `verified` tinyint(1) DEFAULT 0,
            `verified_by` int(11) DEFAULT NULL,
            `verified_at` timestamp NULL DEFAULT NULL,
            PRIMARY KEY (`id`),
            KEY `idx_check` (`check_id`),
            KEY `idx_worker` (`worker_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ",

    "rtw_share_codes" => "
        CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "rtw_share_codes` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `worker_id` int(11) NOT NULL,
            `share_code` varchar(20) NOT NULL,
            `date_provided` date NOT NULL,
            `expiry_date` date DEFAULT NULL,
            `check_performed` tinyint(1) DEFAULT 0,
            `check_date` datetime DEFAULT NULL,
            `check_result` enum('valid','invalid','expired','pending') DEFAULT 'pending',
            `profile_url` varchar(500) DEFAULT NULL,
            `checked_by` int(11) DEFAULT NULL,
            `notes` text DEFAULT NULL,
            `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            KEY `idx_worker` (`worker_id`),
            KEY `idx_share_code` (`share_code`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ",

    "rtw_reminders" => "
        CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "rtw_reminders` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `worker_id` int(11) NOT NULL,
            `check_id` int(11) DEFAULT NULL,
            `reminder_type` enum('expiry','annual','follow_up','missing') NOT NULL,
            `reminder_date` date NOT NULL,
            `days_before` int(11) DEFAULT 30,
            `sent` tinyint(1) DEFAULT 0,
            `sent_date` datetime DEFAULT NULL,
            `sent_to` varchar(255) DEFAULT NULL,
            `acknowledged` tinyint(1) DEFAULT 0,
            `acknowledged_by` int(11) DEFAULT NULL,
            `acknowledged_date` datetime DEFAULT NULL,
            `notes` text DEFAULT NULL,
            `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            KEY `idx_worker` (`worker_id`),
            KEY `idx_reminder_date` (`reminder_date`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ",

    "rtw_audit" => "
        CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "rtw_audit` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `worker_id` int(11) NOT NULL,
            `check_id` int(11) DEFAULT NULL,
            `action` varchar(100) NOT NULL,
            `details` text DEFAULT NULL,
            `performed_by` int(11) NOT NULL,
            `ip_address` varchar(45) DEFAULT NULL,
            `user_agent` varchar(255) DEFAULT NULL,
            `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            KEY `idx_worker` (`worker_id`),
            KEY `idx_check` (`check_id`),
            KEY `idx_action` (`action`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    "
];

// Create each table
foreach ($tables as $table_name => $sql) {
    try {
        $pdo->exec($sql);
        echo "<p style='color: green;'>✓ Table " . DB_PREFIX . $table_name . " created successfully</p>";
        $tables_created++;
    } catch (PDOException $e) {
        $errors[] = "Error creating table $table_name: " . $e->getMessage();
        echo "<p style='color: red;'>✗ Error creating table " . DB_PREFIX . $table_name . ": " . $e->getMessage() . "</p>";
    }
}

// Summary
echo "<hr>";
if (empty($errors)) {
    echo "<h3 style='color: green;'>Success! All $tables_created RTW tables have been created.</h3>";
    echo "<p>You can now <a href='list.php'>go to RTW Checks</a></p>";
} else {
    echo "<h3 style='color: orange;'>Partial Success</h3>";
    echo "<p>Created $tables_created tables, but encountered " . count($errors) . " error(s).</p>";
    echo "<p>Please check the errors above and try again.</p>";
}
?>