-- Create table for share code submissions
CREATE TABLE IF NOT EXISTS `scms_rtw_share_code_submissions` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `worker_id` int(11) NOT NULL,
    `share_code` varchar(20) NOT NULL,
    `document_type` varchar(50) DEFAULT 'share_code',
    `document_path` varchar(255) DEFAULT NULL,
    `additional_info` text,
    `submission_status` enum('pending','verified','rejected','expired') DEFAULT 'pending',
    `verified_by` int(11) DEFAULT NULL,
    `verified_at` datetime DEFAULT NULL,
    `verification_notes` text,
    `submitted_by` int(11) DEFAULT NULL,
    `submitted_at` datetime NOT NULL,
    `expires_at` date DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `worker_id` (`worker_id`),
    KEY `submission_status` (`submission_status`),
    KEY `submitted_at` (`submitted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Add index for quick lookups
ALTER TABLE `scms_rtw_share_code_submissions`
ADD INDEX `idx_worker_status` (`worker_id`, `submission_status`);

-- Create table for share code reminder log
CREATE TABLE IF NOT EXISTS `scms_rtw_reminder_log` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `worker_id` int(11) NOT NULL,
    `reminder_type` varchar(50) NOT NULL,
    `sent_at` datetime NOT NULL,
    `sent_to` varchar(255) NOT NULL,
    `email_status` varchar(20) DEFAULT 'sent',
    `next_reminder_date` date DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `worker_id` (`worker_id`),
    KEY `sent_at` (`sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;