<?php
/**
 * Add RTW Check
 * Fixed version with proper integration
 */

$page_title = 'Add RTW Check';
$current_page = 'rtw';

// Include header which handles authentication and database
require_once '../../includes/header.php';


$worker_id = $_GET['worker_id'] ?? '';
$errors = [];
$success = false;

// Get workers for dropdown
$workers = [];
try {
    $workers_sql = "SELECT id, full_name, employee_number FROM " . DB_PREFIX . "sponsored_workers
                    WHERE status = 'active' ORDER BY full_name";
    $workers = $pdo->query($workers_sql)->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $errors[] = "Could not load workers list";
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $worker_id = $_POST['worker_id'] ?? '';
    $check_date = $_POST['check_date'] ?? '';
    $check_type = $_POST['check_type'] ?? '';
    $document_type = $_POST['document_type'] ?? '';
    $document_number = $_POST['document_number'] ?? '';
    $document_expiry = $_POST['document_expiry'] ?? null;
    $documents_seen = trim($_POST['documents_seen'] ?? '');
    $share_code_used = trim($_POST['share_code_used'] ?? '');
    $online_check = isset($_POST['online_check']) ? 1 : 0;
    $outcome = $_POST['outcome'] ?? '';
    $next_check_due = $_POST['next_check_due'] ?? null;
    $notes = trim($_POST['notes'] ?? '');

    // Validation
    if (empty($worker_id)) $errors[] = "Please select a worker";
    if (empty($check_date)) $errors[] = "Check date is required";
    if (empty($check_type)) $errors[] = "Check type is required";
    if (empty($documents_seen)) $errors[] = "Documents seen is required";
    if (empty($outcome)) $errors[] = "Outcome is required";

    if (empty($errors)) {
        try {
            // Check if table exists
            $check_table = $pdo->query("SHOW TABLES LIKE '" . DB_PREFIX . "worker_rtw_checks'");
            if ($check_table->rowCount() == 0) {
                $errors[] = "RTW tables not found. Please run the installation SQL.";
            } else {
                $stmt = $pdo->prepare("
                    INSERT INTO " . DB_PREFIX . "worker_rtw_checks
                    (worker_id, check_date, check_type, document_type, document_number, document_expiry,
                     documents_seen, share_code_used, online_check, outcome, next_check_due,
                     checked_by, notes, created_at)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())
                ");

                $stmt->execute([
                    $worker_id,
                    $check_date,
                    $check_type,
                    $document_type,
                    $document_number,
                    $document_expiry ?: null,
                    $documents_seen,
                    $share_code_used,
                    $online_check,
                    $outcome,
                    $next_check_due ?: null,
                    $_SESSION['user_id'] ?? 1,
                    $notes
                ]);

                $_SESSION['success'] = 'RTW check added successfully';

                // Redirect
                if (!empty($_POST['return_to_worker'])) {
                    header('Location: ../workers/view.php?id=' . $worker_id);
                } else {
                    header('Location: list.php');
                }
                exit;
            }
        } catch (PDOException $e) {
            $errors[] = "Database error: " . $e->getMessage();
        }
    }
}
?>

<div class="dashboard-container">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="modern-card">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="bi bi-plus-circle"></i> Add Right to Work Check
                    </h5>
                </div>
                <div class="card-body">
                    <?php if (!empty($errors)): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php foreach ($errors as $error): ?>
                                    <li><?php echo htmlspecialchars($error); ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <form method="POST">
                        <?php if (!empty($_GET['worker_id'])): ?>
                            <input type="hidden" name="return_to_worker" value="1">
                        <?php endif; ?>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Worker <span class="text-danger">*</span></label>
                                <select name="worker_id" class="form-select" required>
                                    <option value="">Select worker...</option>
                                    <?php foreach ($workers as $worker): ?>
                                        <option value="<?php echo $worker['id']; ?>"
                                                <?php echo $worker_id == $worker['id'] ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($worker['full_name']); ?>
                                            (<?php echo htmlspecialchars($worker['employee_number']); ?>)
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">Check Date <span class="text-danger">*</span></label>
                                <input type="date" name="check_date" class="form-control"
                                       required value="<?php echo date('Y-m-d'); ?>">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Check Type <span class="text-danger">*</span></label>
                                <select name="check_type" class="form-select" required>
                                    <option value="">Select type...</option>
                                    <option value="initial">Initial (Pre-employment)</option>
                                    <option value="follow_up">Follow-up</option>
                                    <option value="annual">Annual</option>
                                    <option value="retrospective">Retrospective</option>
                                </select>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">Outcome <span class="text-danger">*</span></label>
                                <select name="outcome" class="form-select" required>
                                    <option value="">Select outcome...</option>
                                    <option value="pass">Pass - Right to work confirmed</option>
                                    <option value="fail">Fail - No right to work</option>
                                    <option value="refer">Refer - Further checks required</option>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Primary Document Type</label>
                                <select name="document_type" class="form-select">
                                    <option value="">Select document...</option>
                                    <optgroup label="List A - Permanent Right">
                                        <option value="UK Passport">UK Passport</option>
                                        <option value="Irish Passport">Irish Passport</option>
                                        <option value="EU Settled Status">EU/EEA/Swiss with Settled Status</option>
                                        <option value="UK Birth Certificate">UK Birth/Adoption Certificate + NI</option>
                                    </optgroup>
                                    <optgroup label="List B - Temporary Right">
                                        <option value="BRP">Biometric Residence Permit (BRP)</option>
                                        <option value="Visa">Passport with Visa</option>
                                        <option value="Share Code">Online Share Code</option>
                                        <option value="Frontier Worker">Frontier Worker Permit</option>
                                        <option value="Other">Other Valid Document</option>
                                    </optgroup>
                                </select>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">Document Number</label>
                                <input type="text" name="document_number" class="form-control"
                                       placeholder="e.g., Passport number, BRP number">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Document Expiry Date</label>
                                <input type="date" name="document_expiry" class="form-control">
                                <small class="text-muted">If applicable</small>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">Next Check Due</label>
                                <input type="date" name="next_check_due" class="form-control">
                                <small class="text-muted">Leave blank if not required</small>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Documents Seen <span class="text-danger">*</span></label>
                            <textarea name="documents_seen" class="form-control" rows="3" required
                                      placeholder="List all documents checked (e.g., UK Passport, BRP, Share Code...)"></textarea>
                            <small class="text-muted">Provide details of all documents examined</small>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Share Code (if used)</label>
                                <input type="text" name="share_code_used" class="form-control"
                                       maxlength="20" placeholder="e.g., AB12C3D4E">
                                <small class="text-muted">For online RTW checks</small>
                            </div>

                            <div class="col-md-6 mb-3 d-flex align-items-end">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input"
                                           name="online_check" value="1" id="onlineCheck">
                                    <label class="form-check-label" for="onlineCheck">
                                        Online Check Performed
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Notes</label>
                            <textarea name="notes" class="form-control" rows="3"
                                      placeholder="Additional notes about this check..."></textarea>
                        </div>

                        <div class="alert alert-info">
                            <h6 class="alert-heading"><i class="bi bi-info-circle"></i> Important Reminders</h6>
                            <ul class="mb-0">
                                <li>Keep copies of all RTW documents for audit purposes</li>
                                <li>Record the actual date when documents were physically checked</li>
                                <li>Set follow-up dates for List B (time-limited) documents</li>
                                <li>Ensure you have established a statutory excuse</li>
                            </ul>
                        </div>

                        <hr>

                        <div class="d-flex justify-content-between">
                            <a href="list.php" class="btn btn-secondary">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-circle"></i> Add RTW Check
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Help Section -->
            <div class="card mt-3">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-question-circle"></i> RTW Check Types Explained</h6>
                </div>
                <div class="card-body">
                    <dl class="row mb-0">
                        <dt class="col-sm-3">Initial Check</dt>
                        <dd class="col-sm-9">Performed before employment starts to establish right to work</dd>

                        <dt class="col-sm-3">Follow-up Check</dt>
                        <dd class="col-sm-9">Required before visa/permit expiry for List B documents</dd>

                        <dt class="col-sm-3">Annual Check</dt>
                        <dd class="col-sm-9">Yearly verification for workers with indefinite leave</dd>

                        <dt class="col-sm-3">Retrospective</dt>
                        <dd class="col-sm-9">Check performed for existing employees (e.g., after TUPE transfer)</dd>
                    </dl>
                    <hr>
                    <p class="mb-0"><strong>List A:</strong> Permanent right to work - no follow-up required</p>
                    <p class="mb-0"><strong>List B:</strong> Time-limited right - follow-up required before expiry</p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once '../../includes/footer.php'; ?>