<?php
/**
 * Migration: Add manager_id to work_locations table
 * Run this file once to add the manager_id column
 */

session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';
require_once '../../includes/session_manager.php';

require_authentication();

// Check admin permission
$current_user = get_logged_in_user();
if ($current_user['permission_level'] < 100) {
    die('Access denied. Admin permission required.');
}

$pdo = get_database_connection();
$results = [];

try {
    // Check if migration already ran
    $check = $pdo->query("SHOW COLUMNS FROM " . DB_PREFIX . "work_locations LIKE 'manager_id'");
    if ($check->rowCount() > 0) {
        $results[] = "✓ Migration already completed - manager_id column exists";
    } else {
        // Add manager_id field
        $pdo->exec("ALTER TABLE " . DB_PREFIX . "work_locations
            ADD COLUMN manager_id INT NULL AFTER capacity,
            ADD INDEX idx_manager_id (manager_id)");

        $results[] = "✓ Added manager_id field to work_locations table";
    }

    echo "=== MANAGER ID MIGRATION ===" . PHP_EOL . PHP_EOL;
    echo "RESULTS:" . PHP_EOL;
    foreach ($results as $result) {
        echo $result . PHP_EOL;
    }
    echo PHP_EOL . "✓ Migration completed successfully!" . PHP_EOL;

} catch (PDOException $e) {
    echo "ERROR: " . $e->getMessage() . PHP_EOL;
    exit(1);
}
?>
