-- Add shift timing fields to work_locations table
ALTER TABLE scms_work_locations
ADD COLUMN shift_start_time TIME DEFAULT '09:00:00' AFTER capacity,
ADD COLUMN shift_end_time TIME DEFAULT '17:00:00' AFTER shift_start_time,
ADD COLUMN shift_name VARCHAR(100) DEFAULT 'Day Shift' AFTER shift_end_time;

-- Add location_id to sponsored_workers table
ALTER TABLE scms_sponsored_workers
ADD COLUMN location_id INT NULL AFTER department,
ADD INDEX idx_location_id (location_id);

-- Optional: Add foreign key constraint (uncomment if you want strict referential integrity)
-- ALTER TABLE scms_sponsored_workers
-- ADD CONSTRAINT fk_worker_location
-- FOREIGN KEY (location_id) REFERENCES scms_work_locations(id)
-- ON DELETE SET NULL ON UPDATE CASCADE;
