# Work Locations Module

**Version:** 1.0.0
**Status:** ✅ Production Ready
**Module ID:** `locations`

---

## Overview

The Work Locations module manages all office locations, warehouses, construction sites, and remote work locations. It tracks worker assignments, capacity management, site managers, and provides comprehensive location-based reporting for compliance and operational efficiency.

---

## Features

### ✅ Core Features
1. **Location Management** - Track all work locations (offices, warehouses, sites)
2. **Capacity Tracking** - Monitor location capacity and current occupancy
3. **Worker Assignment** - Assign workers to specific locations
4. **Site Manager Assignment** - Designate managers for each location
5. **Address Management** - Full UK address with postcode
6. **GPS Coordinates** - Latitude/longitude for mapping
7. **Facility Tracking** - Track facilities available at each location
8. **Document Storage** - Store location documents (leases, certificates)
9. **Historical Tracking** - Complete worker assignment history

### 📋 CRUD Operations
- ✅ **List/View** - View all locations with statistics
- ✅ **Add** - Create new work locations
- ✅ **Edit** - Update location details
- ✅ **View** - Detailed location info with worker list
- ✅ **Delete** - Remove locations (with safety checks)

---

## Database Schema

### Tables Created
1. **scms_work_locations** - Main locations table
2. **scms_location_assignments** - Worker assignment history
3. **scms_location_capacity_log** - Historical capacity tracking
4. **scms_location_documents** - Location-related documents

### Key Fields
- `name` - Location name
- `type` - office | warehouse | site | remote | other
- `address` - Full address with line1, line2, city, county, postcode
- `latitude`, `longitude` - GPS coordinates
- `capacity` - Maximum worker capacity
- `current_occupancy` - Current number of workers
- `manager_id` - Site manager (FK to scms_sponsored_workers)
- `status` - active | inactive | closed

---

## File Structure

```
/modules/locations/
├── module.json           # Module configuration
├── list.php             # Main list page with statistics
├── add.php              # Add new location
├── edit.php             # Edit location details
├── view.php             # View location with worker list
├── delete.php           # Delete location (with checks)
├── database_schema.sql  # Complete database schema
└── README.md           # This file
```

---

## Installation

1. **Activate Module**
   - Go to Settings → Modules
   - Find "Work Locations"
   - Click "Activate"

2. **Create Database Tables**
   ```bash
   mysql -u username -p database_name < modules/locations/database_schema.sql
   ```

3. **Set Permissions**
   - `locations.view` (Level 30+) - View locations
   - `locations.add` (Level 70+) - Add new locations
   - `locations.edit` (Level 70+) - Edit locations
   - `locations.delete` (Level 90+) - Delete locations

---

## Usage Guide

### Adding a New Location

1. Navigate to **Locations**
2. Click **Add Location**
3. Enter:
   - **Location Name** (required)
   - **Type** (Office, Warehouse, Site, Remote)
   - **Full Address** (with postcode)
   - **Capacity** (maximum workers)
   - **Site Manager** (optional)
   - **Status** (Active/Inactive)
4. Click **Add Location**

### Assigning Workers to Location

**Method 1: Via Worker Profile**
1. Go to Workers module
2. Edit worker
3. Select "Work Location" from dropdown
4. Save changes

**Method 2: Via Location View**
1. Go to Locations
2. Click **View** on location
3. See current workers assigned
4. Edit individual workers to change assignment

### Managing Capacity

The system automatically tracks:
- **Capacity** - Maximum workers set for location
- **Current Occupancy** - Actual workers assigned
- **Utilization %** - Occupancy as percentage of capacity

**Capacity Alerts:**
- Over 90% - Shows warning badge
- At 100% - Shows full badge
- Historical tracking for trend analysis

### Assigning Site Manager

1. Go to Locations
2. Click **Edit** on location
3. Select manager from "Site Manager" dropdown
   - Only active workers shown
4. Click **Update Location**

---

## Location Types

### Office
- Head office, branch offices
- Facilities: Parking, WiFi, Canteen, Meeting rooms

### Warehouse
- Storage facilities, distribution centers
- Facilities: Loading bays, Storage capacity, Security

### Site
- Construction sites, project locations
- Facilities: Site office, Welfare facilities, First aid

### Remote
- Remote work locations
- Home offices, client sites

### Other
- Any location not fitting above categories

---

## Statistics Dashboard

Real-time location statistics:

- **Total Locations** - All locations in system
- **Active Locations** - Currently active locations
- **Total Capacity** - Sum of all location capacities
- **Current Workers** - Workers across all locations
- **Utilization Rate** - Overall capacity utilization %

---

## Worker Assignment History

The module tracks complete assignment history:

- **Worker ID** - Which worker
- **Location ID** - Which location
- **Assignment Date** - When assigned
- **End Date** - When assignment ended (NULL = current)
- **Assignment Type** - Permanent | Temporary | Remote
- **Reason** - Why assigned
- **Assigned By** - User who made assignment

This provides:
- Complete audit trail
- Historical analysis
- Compliance reporting
- Trend analysis

---

## Document Management

Store location-specific documents:

### Document Types
- **Lease Agreement** - Property lease
- **Health & Safety Certificate** - H&S compliance
- **Fire Safety Certificate** - Fire safety compliance
- **Insurance Document** - Property insurance
- **Site Plan/Layout** - Location layout
- **Other Documents**

### Features
- File upload with type categorization
- Expiry date tracking
- Automatic expiry alerts
- Secure storage
- Access control

---

## Integration with Other Modules

### Workers Module
- Assign workers to locations
- View worker location history
- Track location on worker profile
- Reports by location

### Attendance Module
- Track attendance by location
- Location-specific attendance reports
- Site-based time tracking

### Reports Module
- Worker distribution by location
- Capacity utilization reports
- Location compliance reports
- Assignment history reports

---

## Capacity Management

### Automatic Tracking
The system uses database triggers to automatically update `current_occupancy`:

```sql
-- When worker assigned to location:
current_occupancy = current_occupancy + 1

-- When worker removed from location:
current_occupancy = current_occupancy - 1
```

### Capacity Logging
Daily capacity snapshots stored in `scms_location_capacity_log`:
- Date
- Occupancy count
- Capacity
- Utilization percentage

Use for:
- Historical trend analysis
- Capacity planning
- Compliance reporting

---

## GPS & Mapping

### Features
- Store latitude/longitude for each location
- Integration-ready for Google Maps
- Distance calculations
- Route planning
- Mobile app support

### Future Enhancements
- Visual map view of all locations
- Worker location tracking
- Travel distance calculations
- Geofencing alerts

---

## Permissions Matrix

| Action | Permission Level | Description |
|--------|-----------------|-------------|
| View Locations | 30+ | View location list and details |
| Add Location | 70+ | Create new locations |
| Edit Location | 70+ | Modify location details |
| Assign Manager | 70+ | Assign site managers |
| Delete Location | 90+ | Permanently delete (with checks) |

---

## Safety Features

### Delete Protection
Cannot delete location if:
- Has workers currently assigned
- Has active assignments

System will:
1. Count assigned workers
2. Show error message
3. Suggest reassignment
4. Prevent deletion

---

## Security Features

- ✅ Permission-based access control
- ✅ SQL injection protection
- ✅ XSS prevention
- ✅ CSRF protection
- ✅ Complete audit trail
- ✅ Secure document storage
- ✅ Input validation

---

## Technical Details

**Language:** PHP 7.4+
**Database:** MySQL/MariaDB with triggers
**Frontend:** Bootstrap 5, Dark Mode Compatible
**Dependencies:** Workers module (recommended)

---

## Troubleshooting

### Location not appearing in dropdown
- Verify status is "active"
- Check module is activated
- Refresh browser cache

### Cannot delete location
- Check if workers assigned
- Reassign all workers first
- Or set status to "inactive" instead

### Occupancy count incorrect
- Database trigger may need to be recreated
- Run schema SQL to recreate triggers
- Or manually update count:
  ```sql
  UPDATE scms_work_locations l
  SET current_occupancy = (
    SELECT COUNT(*) FROM scms_sponsored_workers
    WHERE work_location_id = l.id
  )
  ```

---

## Compliance & Reporting

### UK Sponsor Duties
- Track worker locations for Home Office reporting
- Site-specific compliance records
- Location audit trail

### Health & Safety
- Store H&S documents per location
- Track facility availability
- Access instructions
- Emergency procedures

### GDPR
- Worker location data
- Secure storage
- Access controls
- Audit logging

---

## Support

- **Documentation:** `/docs/modules/locations/`
- **Technical Support:** Contact system administrator

---

## Future Enhancements

Planned for v1.1:
- [ ] Google Maps integration
- [ ] Mobile check-in/out at locations
- [ ] QR code location tags
- [ ] Capacity planning tool
- [ ] Location expense tracking
- [ ] Advanced analytics dashboard
- [ ] Geofencing alerts
- [ ] Multi-location worker management

---

**Last Updated:** October 17, 2025
**Module Status:** ✅ Production Ready
**Compliance:** UK H&S & GDPR Compliant
