<?php
require __DIR__ . '/../../config/database.php';
require __DIR__ . '/../../includes/functions.php';

require_login();
$page_title = 'View Holiday Request';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Get request
$stmt = $pdo->prepare("
    SELECT hr.*, 
    CONCAT(sw.first_name, ' ', sw.last_name) as worker_name,
    sw.employee_number,
    sw.department,
    CONCAT(req_user.full_name) as requested_by_name,
    CONCAT(app_user.full_name) as approved_by_name
    FROM holiday_requests hr
    JOIN sponsored_workers sw ON hr.worker_id = sw.id
    LEFT JOIN users req_user ON hr.requested_by = req_user.id
    LEFT JOIN users app_user ON hr.approved_by = app_user.id
    WHERE hr.id = ? AND hr.business_profile_id = ?
");
$stmt->execute([$id, $_SESSION['business_profile_id']]);
$request = $stmt->fetch();

if (!$request) {
    $_SESSION['error'] = "Holiday request not found";
    header('Location: list.php');
    exit;
}

require __DIR__ . '/../../includes/header.php';
?>

<div class="row mb-4">
    <div class="col-md-8">
        <h2><i class="bi bi-calendar-check"></i> Holiday Request Details</h2>
    </div>
    <div class="col-md-4 text-end">
        <a href="list.php" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Back to List
        </a>
    </div>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="stat-card">
            <!-- Status Badge -->
            <div class="mb-4">
                <?php
                $badge_class = match($request['approval_status']) {
                    'Approved' => 'bg-success',
                    'Rejected' => 'bg-danger',
                    'Pending' => 'bg-warning',
                    default => 'bg-secondary'
                };
                ?>
                <span class="badge <?= $badge_class ?> fs-5">
                    <?= htmlspecialchars($request['approval_status']) ?>
                </span>
            </div>
            
            <!-- Worker Details -->
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label text-muted">Worker</label>
                    <p class="fw-bold">
                        <a href="../workers/view.php?id=<?= $request['worker_id'] ?>">
                            <?= htmlspecialchars($request['worker_name']) ?>
                        </a>
                    </p>
                </div>
                <div class="col-md-6">
                    <label class="form-label text-muted">Employee Number</label>
                    <p class="fw-bold"><?= htmlspecialchars($request['employee_number']) ?></p>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label text-muted">Department</label>
                    <p><?= htmlspecialchars($request['department'] ?: 'Not specified') ?></p>
                </div>
                <div class="col-md-6">
                    <label class="form-label text-muted">Leave Type</label>
                    <p><?= htmlspecialchars($request['leave_type']) ?></p>
                </div>
            </div>
            
            <hr>
            
            <!-- Leave Dates -->
            <div class="row mb-3">
                <div class="col-md-4">
                    <label class="form-label text-muted">Start Date</label>
                    <p class="fw-bold"><?= date('d/m/Y', strtotime($request['start_date'])) ?></p>
                </div>
                <div class="col-md-4">
                    <label class="form-label text-muted">End Date</label>
                    <p class="fw-bold"><?= date('d/m/Y', strtotime($request['end_date'])) ?></p>
                </div>
                <div class="col-md-4">
                    <label class="form-label text-muted">Total Days</label>
                    <p class="fw-bold fs-5 text-primary"><?= $request['total_days'] ?> days</p>
                </div>
            </div>
            
            <hr>
            
            <!-- Reason -->
            <?php if (!empty($request['reason'])): ?>
            <div class="mb-3">
                <label class="form-label text-muted">Reason</label>
                <p><?= nl2br(htmlspecialchars($request['reason'])) ?></p>
            </div>
            <hr>
            <?php endif; ?>
            
            <!-- Request Info -->
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label text-muted">Requested By</label>
                    <p><?= htmlspecialchars($request['requested_by_name']) ?></p>
                </div>
                <div class="col-md-6">
                    <label class="form-label text-muted">Request Date</label>
                    <p><?= date('d/m/Y H:i', strtotime($request['created_at'])) ?></p>
                </div>
            </div>
            
            <!-- Approval Info -->
            <?php if ($request['approval_status'] !== 'Pending'): ?>
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label text-muted">
                        <?= $request['approval_status'] === 'Approved' ? 'Approved By' : 'Rejected By' ?>
                    </label>
                    <p><?= htmlspecialchars($request['approved_by_name'] ?: 'Unknown') ?></p>
                </div>
                <div class="col-md-6">
                    <label class="form-label text-muted">Decision Date</label>
                    <p><?= $request['approval_date'] ? date('d/m/Y H:i', strtotime($request['approval_date'])) : 'N/A' ?></p>
                </div>
            </div>
            
            <?php if (!empty($request['approval_notes'])): ?>
            <div class="mb-3">
                <label class="form-label text-muted">Manager Notes</label>
                <div class="alert alert-secondary">
                    <?= nl2br(htmlspecialchars($request['approval_notes'])) ?>
                </div>
            </div>
            <?php endif; ?>
            <?php endif; ?>
            
            <!-- Actions -->
            <div class="d-flex gap-2 mt-4">
                <?php if ($request['approval_status'] === 'Pending' && $_SESSION['permission_level'] >= 70): ?>
                <a href="approve.php?id=<?= $request['id'] ?>" class="btn btn-success">
                    <i class="bi bi-check-circle"></i> Review Request
                </a>
                <?php endif; ?>
                
                <a href="list.php" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Back to List
                </a>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="stat-card">
            <h5 class="mb-3"><i class="bi bi-calendar3"></i> Calendar Preview</h5>
            <div class="d-flex justify-content-between mb-2">
                <span>Start:</span>
                <strong><?= date('d M Y', strtotime($request['start_date'])) ?></strong>
            </div>
            <div class="d-flex justify-content-between mb-2">
                <span>End:</span>
                <strong><?= date('d M Y', strtotime($request['end_date'])) ?></strong>
            </div>
            <div class="d-flex justify-content-between">
                <span>Duration:</span>
                <strong class="text-primary"><?= $request['total_days'] ?> working days</strong>
            </div>
        </div>
        
        <div class="stat-card mt-3">
            <h6><i class="bi bi-info-circle"></i> Request Status</h6>
            <div class="mt-3">
                <div class="d-flex align-items-center mb-2">
                    <i class="bi bi-check-circle-fill text-success me-2"></i>
                    <span>Request Submitted</span>
                </div>
                <div class="d-flex align-items-center mb-2">
                    <?php if ($request['approval_status'] !== 'Pending'): ?>
                    <i class="bi bi-check-circle-fill text-success me-2"></i>
                    <?php else: ?>
                    <i class="bi bi-circle me-2 text-muted"></i>
                    <?php endif; ?>
                    <span>Manager Review</span>
                </div>
                <div class="d-flex align-items-center">
                    <?php if ($request['approval_status'] === 'Approved'): ?>
                    <i class="bi bi-check-circle-fill text-success me-2"></i>
                    <?php else: ?>
                    <i class="bi bi-circle me-2 text-muted"></i>
                    <?php endif; ?>
                    <span>Approved</span>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require __DIR__ . '/../../includes/footer.php'; ?>
