<?php
session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';
require_once '../../includes/session_manager.php';

require_authentication();
require_permission(80);

$cos_id = $_GET['id'] ?? 0;
$errors = [];

// Fetch CoS record
$stmt = $pdo->prepare("SELECT * FROM " . DB_PREFIX . "cos_records WHERE id = ?");
$stmt->execute([$cos_id]);
$cos = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$cos) {
    $_SESSION['error'] = 'CoS record not found';
    header('Location: list.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $reason = trim($_POST['reason'] ?? '');

    if (empty($reason)) {
        $errors[] = "Withdrawal reason is required";
    }

    if (empty($errors)) {
        try {
            $stmt = $pdo->prepare("UPDATE " . DB_PREFIX . "cos_records
                SET status = 'withdrawn',
                    notes = CONCAT(notes, '\n\n[WITHDRAWN] ', NOW(), ': ', ?),
                    updated_at = NOW()
                WHERE id = ?");
            $stmt->execute([$reason, $cos_id]);

            $_SESSION['success'] = 'CoS withdrawn successfully';
            header('Location: list.php');
            exit;
        } catch (PDOException $e) {
            $errors[] = 'Database error: ' . $e->getMessage();
        }
    }
}

$page_title = 'Withdraw CoS';
include '../../includes/header.php';
?>

<div class="dashboard-container">
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="modern-card">
                <div class="card-header-modern">
                    <h5 class="card-title-modern"><i class="bi bi-x-circle"></i> Withdraw CoS</h5>
                </div>
                <div class="card-body-modern">
                    <?php if (!empty($errors)): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0"><?php foreach ($errors as $error): ?><li><?php echo htmlspecialchars($error); ?></li><?php endforeach; ?></ul>
                        </div>
                    <?php endif; ?>

                    <div class="alert alert-danger">
                        <i class="bi bi-exclamation-triangle"></i>
                        <strong>Withdraw CoS</strong>
                        <p class="mb-0 mt-2">You are about to withdraw this Certificate of Sponsorship. This action should be reported to the Home Office.</p>
                    </div>

                    <table class="table table-borderless mb-4">
                        <tr>
                            <th width="40%">CoS Number:</th>
                            <td><?php echo htmlspecialchars($cos['cos_number']); ?></td>
                        </tr>
                        <tr>
                            <th>Current Status:</th>
                            <td><span class="badge bg-info"><?php echo ucfirst($cos['status']); ?></span></td>
                        </tr>
                        <tr>
                            <th>New Status:</th>
                            <td><span class="badge bg-warning">Withdrawn</span></td>
                        </tr>
                    </table>

                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label">Reason for Withdrawal <span class="text-danger">*</span></label>
                            <textarea name="reason" class="form-control" rows="4" required placeholder="Please provide a detailed reason for withdrawing this CoS..."></textarea>
                            <small class="text-muted">This will be added to the CoS notes and should include Home Office reporting reference if applicable.</small>
                        </div>

                        <div class="d-flex justify-content-between mt-4">
                            <a href="list.php" class="btn btn-secondary">
                                <i class="bi bi-arrow-left"></i> Cancel
                            </a>
                            <button type="submit" class="btn btn-warning">
                                <i class="bi bi-x-circle"></i> Confirm Withdrawal
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>
