<?php
session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';
require_once '../../includes/session_manager.php';

require_authentication();
require_permission(30);

$cos_id = $_GET['id'] ?? 0;

// Fetch CoS record with worker details
$stmt = $pdo->prepare("SELECT c.*,
    w.full_name as worker_name,
    w.employee_number,
    w.job_title,
    DATEDIFF(c.expiry_date, CURDATE()) as days_to_expiry
    FROM " . DB_PREFIX . "cos_records c
    LEFT JOIN " . DB_PREFIX . "sponsored_workers w ON c.assigned_to = w.id
    WHERE c.id = ?");
$stmt->execute([$cos_id]);
$cos = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$cos) {
    $_SESSION['error'] = 'CoS record not found';
    header('Location: list.php');
    exit;
}

$page_title = 'CoS Details - ' . $cos['cos_number'];
include '../../includes/header.php';
?>

<div class="dashboard-container">
    <div class="modern-card">
        <div class="card-header-modern d-flex justify-content-between align-items-center">
            <h5 class="card-title-modern">
                <i class="bi bi-file-earmark-medical"></i> CoS: <?php echo htmlspecialchars($cos['cos_number']); ?>
            </h5>
            <div>
                <a href="edit.php?id=<?php echo $cos['id']; ?>" class="btn btn-sm btn-primary">
                    <i class="bi bi-pencil"></i> Edit
                </a>
                <a href="list.php" class="btn btn-sm btn-secondary">
                    <i class="bi bi-arrow-left"></i> Back to List
                </a>
            </div>
        </div>
        <div class="card-body-modern">
            <div class="row">
                <!-- CoS Information -->
                <div class="col-md-6">
                    <h6 class="border-bottom pb-2 mb-3"><i class="bi bi-info-circle"></i> CoS Information</h6>
                    <table class="table table-borderless table-sm">
                        <tr>
                            <th width="40%">CoS Number:</th>
                            <td><strong><?php echo htmlspecialchars($cos['cos_number']); ?></strong></td>
                        </tr>
                        <tr>
                            <th>Issue Date:</th>
                            <td><?php echo date('d/m/Y', strtotime($cos['issue_date'])); ?></td>
                        </tr>
                        <tr>
                            <th>Status:</th>
                            <td>
                                <?php
                                $status_colors = [
                                    'assigned' => 'info',
                                    'used' => 'success',
                                    'withdrawn' => 'warning',
                                    'expired' => 'danger'
                                ];
                                $color = $status_colors[$cos['status']] ?? 'secondary';
                                ?>
                                <span class="badge bg-<?php echo $color; ?>"><?php echo ucfirst($cos['status']); ?></span>
                            </td>
                        </tr>
                        <tr>
                            <th>Cost:</th>
                            <td><strong>£<?php echo number_format($cos['cost'], 2); ?></strong></td>
                        </tr>
                        <tr>
                            <th>Expiry Date:</th>
                            <td>
                                <?php if ($cos['expiry_date']): ?>
                                    <?php echo date('d/m/Y', strtotime($cos['expiry_date'])); ?>
                                    <?php if ($cos['days_to_expiry'] !== null): ?>
                                        <?php if ($cos['days_to_expiry'] < 0): ?>
                                            <span class="badge bg-danger ms-2">Expired</span>
                                        <?php elseif ($cos['days_to_expiry'] <= 30): ?>
                                            <span class="badge bg-warning ms-2"><?php echo $cos['days_to_expiry']; ?> days</span>
                                        <?php else: ?>
                                            <span class="badge bg-success ms-2"><?php echo $cos['days_to_expiry']; ?> days</span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="text-muted">Not set</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    </table>
                </div>

                <!-- Worker Assignment -->
                <div class="col-md-6">
                    <h6 class="border-bottom pb-2 mb-3"><i class="bi bi-person"></i> Worker Assignment</h6>
                    <?php if ($cos['worker_name']): ?>
                        <table class="table table-borderless table-sm">
                            <tr>
                                <th width="40%">Worker Name:</th>
                                <td>
                                    <a href="../workers/view.php?id=<?php echo $cos['assigned_to']; ?>">
                                        <?php echo htmlspecialchars($cos['worker_name']); ?>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <th>Employee Number:</th>
                                <td><?php echo htmlspecialchars($cos['employee_number']); ?></td>
                            </tr>
                            <tr>
                                <th>Job Title:</th>
                                <td><?php echo htmlspecialchars($cos['job_title'] ?? '-'); ?></td>
                            </tr>
                        </table>
                        <a href="../workers/view.php?id=<?php echo $cos['assigned_to']; ?>" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-eye"></i> View Worker Profile
                        </a>
                    <?php else: ?>
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle"></i> This CoS is not currently assigned to any worker.
                        </div>
                        <a href="edit.php?id=<?php echo $cos['id']; ?>" class="btn btn-sm btn-primary">
                            <i class="bi bi-person-plus"></i> Assign to Worker
                        </a>
                    <?php endif; ?>
                </div>
            </div>

            <?php if ($cos['notes']): ?>
            <hr>
            <div class="row">
                <div class="col-12">
                    <h6 class="border-bottom pb-2 mb-3"><i class="bi bi-sticky"></i> Notes</h6>
                    <div class="alert alert-secondary">
                        <?php echo nl2br(htmlspecialchars($cos['notes'])); ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <hr>
            <div class="row">
                <div class="col-12">
                    <h6 class="border-bottom pb-2 mb-3"><i class="bi bi-clock-history"></i> Timeline</h6>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="bi bi-circle-fill text-primary" style="font-size: 8px;"></i>
                            <strong>Created:</strong> <?php echo date('d/m/Y H:i', strtotime($cos['created_at'])); ?>
                        </li>
                        <?php if ($cos['updated_at'] && $cos['updated_at'] !== $cos['created_at']): ?>
                        <li class="mb-2">
                            <i class="bi bi-circle-fill text-info" style="font-size: 8px;"></i>
                            <strong>Last Updated:</strong> <?php echo date('d/m/Y H:i', strtotime($cos['updated_at'])); ?>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>

            <?php if ($cos['status'] === 'assigned' && has_permission(70)): ?>
            <hr>
            <div class="d-flex gap-2">
                <a href="use.php?id=<?php echo $cos['id']; ?>" class="btn btn-success">
                    <i class="bi bi-check-circle"></i> Mark as Used
                </a>
                <a href="withdraw.php?id=<?php echo $cos['id']; ?>" class="btn btn-warning" onclick="return confirm('Are you sure you want to withdraw this CoS?')">
                    <i class="bi bi-x-circle"></i> Withdraw CoS
                </a>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>
