<?php
session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';
require_once '../../includes/session_manager.php';

require_authentication();
require_permission(70);

$cos_id = $_GET['id'] ?? 0;

// Fetch CoS record
$stmt = $pdo->prepare("SELECT * FROM " . DB_PREFIX . "cos_records WHERE id = ?");
$stmt->execute([$cos_id]);
$cos = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$cos) {
    $_SESSION['error'] = 'CoS record not found';
    header('Location: list.php');
    exit;
}

if ($cos['status'] !== 'assigned') {
    $_SESSION['error'] = 'Only assigned CoS can be marked as used';
    header('Location: list.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $stmt = $pdo->prepare("UPDATE " . DB_PREFIX . "cos_records
            SET status = 'used', updated_at = NOW()
            WHERE id = ?");
        $stmt->execute([$cos_id]);

        $_SESSION['success'] = 'CoS marked as used successfully';
        header('Location: list.php');
        exit;
    } catch (PDOException $e) {
        $_SESSION['error'] = 'Database error: ' . $e->getMessage();
        header('Location: list.php');
        exit;
    }
}

$page_title = 'Mark CoS as Used';
include '../../includes/header.php';
?>

<div class="dashboard-container">
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="modern-card">
                <div class="card-header-modern">
                    <h5 class="card-title-modern"><i class="bi bi-check-circle"></i> Mark CoS as Used</h5>
                </div>
                <div class="card-body-modern">
                    <div class="alert alert-warning">
                        <i class="bi bi-exclamation-triangle"></i>
                        <strong>Confirm Action</strong>
                        <p class="mb-0 mt-2">Are you sure you want to mark this CoS as <strong>USED</strong>?</p>
                    </div>

                    <table class="table table-borderless">
                        <tr>
                            <th>CoS Number:</th>
                            <td><?php echo htmlspecialchars($cos['cos_number']); ?></td>
                        </tr>
                        <tr>
                            <th>Current Status:</th>
                            <td><span class="badge bg-info">Assigned</span></td>
                        </tr>
                        <tr>
                            <th>New Status:</th>
                            <td><span class="badge bg-success">Used</span></td>
                        </tr>
                    </table>

                    <form method="POST">
                        <div class="d-flex justify-content-between mt-4">
                            <a href="list.php" class="btn btn-secondary">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-check-circle"></i> Confirm - Mark as Used
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>
