<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>CoS Module Debug Test</h1>";

// Test 1: Config loads
echo "<h2>1. Testing Config</h2>";
try {
    require_once '../../config/database.php';
    echo "✓ Config loaded<br>";
    echo "✓ Database connected<br>";
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "<br>";
}

// Test 2: Table exists
echo "<h2>2. Testing Table</h2>";
try {
    $stmt = $pdo->query("SHOW TABLES LIKE 'scms_cos_records'");
    if ($stmt->rowCount() > 0) {
        echo "✓ cos_records table EXISTS<br>";
        
        // Get columns
        $cols = $pdo->query("DESCRIBE scms_cos_records");
        echo "Columns: <ul>";
        while ($col = $cols->fetch(PDO::FETCH_ASSOC)) {
            echo "<li>" . $col['Field'] . " (" . $col['Type'] . ")</li>";
        }
        echo "</ul>";
    } else {
        echo "✗ cos_records table MISSING<br>";
    }
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "<br>";
}

// Test 3: Stats query
echo "<h2>3. Testing Stats Query</h2>";
try {
    $stats_sql = "SELECT COUNT(*) as total FROM scms_cos_records";
    $stmt = $pdo->query($stats_sql);
    $stats = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "✓ Total CoS records: " . $stats['total'] . "<br>";
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "<br>";
}

// Test 4: File permissions
echo "<h2>4. File Info</h2>";
echo "index.php size: " . filesize('index.php') . " bytes<br>";
echo "add.php size: " . filesize('add.php') . " bytes<br>";

// Test 5: Check if premium styles exist
echo "<h2>5. Premium Styles Check</h2>";
$content = file_get_contents('index.php');
if (strpos($content, 'premium-card') !== false) {
    echo "✓ Premium card styles FOUND<br>";
} else {
    echo "✗ Premium card styles MISSING<br>";
}

echo "<h2>Done!</h2>";
