<?php
/**
 * CoS Management List
 */

$page_title = 'CoS Management';

// Only include header if not embedded
if (!defined('MODULE_EMBEDDED')) {
    require_once '../../includes/header.php';
}

// Filters
$status_filter = $_GET['status'] ?? '';
$search = $_GET['search'] ?? '';

// Build query
$where = ["1=1"];
$params = [];

if ($status_filter) {
    $where[] = "c.status = ?";
    $params[] = $status_filter;
}

if ($search) {
    $where[] = "(c.cos_number LIKE ? OR w.full_name LIKE ?)";
    $search_term = "%{$search}%";
    $params[] = $search_term;
    $params[] = $search_term;
}

$where_clause = implode(' AND ', $where);

// Fetch CoS records
$sql = "SELECT c.*,
        w.full_name as worker_name,
        w.employee_number,
        DATEDIFF(c.expiry_date, CURDATE()) as days_to_expiry
        FROM " . DB_PREFIX . "cos_records c
        LEFT JOIN " . DB_PREFIX . "sponsored_workers w ON c.assigned_to = w.id
        WHERE $where_clause
        ORDER BY c.created_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$cos_records = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Statistics
$stats_sql = "SELECT
    COUNT(*) as total,
    SUM(CASE WHEN status = 'assigned' THEN 1 ELSE 0 END) as assigned,
    SUM(CASE WHEN status = 'used' THEN 1 ELSE 0 END) as used,
    SUM(CASE WHEN status = 'withdrawn' THEN 1 ELSE 0 END) as withdrawn,
    SUM(CASE WHEN status = 'expired' THEN 1 ELSE 0 END) as expired,
    SUM(cost) as total_cost
    FROM " . DB_PREFIX . "cos_records";
$stats = $pdo->query($stats_sql)->fetch(PDO::FETCH_ASSOC);
?>

<div class="dashboard-container">
    <div class="welcome-section">
        <div class="welcome-content">
            <h1 class="welcome-title">
                <i class="bi bi-file-earmark-medical"></i> CoS Management
            </h1>
            <p class="welcome-subtitle">Track Certificates of Sponsorship</p>
        </div>
        <div class="welcome-actions">
            <a href="<?php echo defined('MODULE_EMBEDDED') ? '../../m/cos/add' : 'add.php'; ?>" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> Add CoS
            </a>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="quick-actions-grid mb-4">
        <!-- Total CoS -->
        <div class="quick-action-btn gradient-blue">
            <div class="quick-action-icon">
                <i class="fas fa-file-medical"></i>
            </div>
            <span class="quick-action-label"><?php echo number_format($stats['total']); ?> Total CoS</span>
        </div>

        <!-- Assigned -->
        <div class="quick-action-btn gradient-cyan">
            <div class="quick-action-icon">
                <i class="ri-user-add-fill"></i>
            </div>
            <span class="quick-action-label"><?php echo number_format($stats['assigned']); ?> Assigned</span>
        </div>

        <!-- Used -->
        <div class="quick-action-btn gradient-green">
            <div class="quick-action-icon">
                <span class="material-symbols-outlined" style="font-size: 1.75rem;">task_alt</span>
            </div>
            <span class="quick-action-label"><?php echo number_format($stats['used']); ?> Used</span>
        </div>

        <!-- Total Cost -->
        <div class="quick-action-btn gradient-purple">
            <div class="quick-action-icon">
                <i class="fas fa-pound-sign"></i>
            </div>
            <span class="quick-action-label">£<?php echo number_format($stats['total_cost'], 0); ?> Total Cost</span>
        </div>
    </div>

    <div class="modern-card">
        <div class="card-body-modern">
            <!-- Filters -->
            <form method="GET" class="row g-3 mb-4">
                <div class="col-md-5">
                    <input type="text" name="search" class="form-control" placeholder="Search CoS number or worker..." value="<?php echo htmlspecialchars($search); ?>">
                </div>
                <div class="col-md-5">
                    <select name="status" class="form-select">
                        <option value="">All Status</option>
                        <option value="assigned" <?php echo $status_filter === 'assigned' ? 'selected' : ''; ?>>Assigned</option>
                        <option value="used" <?php echo $status_filter === 'used' ? 'selected' : ''; ?>>Used</option>
                        <option value="withdrawn" <?php echo $status_filter === 'withdrawn' ? 'selected' : ''; ?>>Withdrawn</option>
                        <option value="expired" <?php echo $status_filter === 'expired' ? 'selected' : ''; ?>>Expired</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100">
                        <i class="bi bi-filter"></i> Filter
                    </button>
                </div>
            </form>

            <!-- CoS Table -->
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>CoS Number</th>
                            <th>Issue Date</th>
                            <th>Assigned To</th>
                            <th>Status</th>
                            <th>Cost</th>
                            <th>Expiry</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($cos_records)): ?>
                        <tr>
                            <td colspan="7" class="text-center py-5">
                                <i class="bi bi-inbox" style="font-size: 3rem; color: #ccc;"></i>
                                <p class="text-muted mt-2">No CoS records found</p>
                                <a href="<?php echo defined('MODULE_EMBEDDED') ? '../../m/cos/add' : 'add.php'; ?>" class="btn btn-primary">
                                    <i class="bi bi-plus-circle"></i> Add First CoS
                                </a>
                            </td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($cos_records as $cos): ?>
                        <tr>
                            <td><strong><?php echo htmlspecialchars($cos['cos_number']); ?></strong></td>
                            <td><?php echo date('d/m/Y', strtotime($cos['issue_date'])); ?></td>
                            <td>
                                <?php if ($cos['worker_name']): ?>
                                    <a href="../workers/view.php?id=<?php echo $cos['assigned_to']; ?>">
                                        <?php echo htmlspecialchars($cos['worker_name']); ?>
                                    </a><br>
                                    <small class="text-muted"><?php echo htmlspecialchars($cos['employee_number']); ?></small>
                                <?php else: ?>
                                    <span class="text-muted">Unassigned</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php
                                $status_colors = [
                                    'assigned' => 'info',
                                    'used' => 'success',
                                    'withdrawn' => 'warning',
                                    'expired' => 'danger'
                                ];
                                $color = $status_colors[$cos['status']] ?? 'secondary';
                                ?>
                                <span class="badge bg-<?php echo $color; ?>"><?php echo ucfirst($cos['status']); ?></span>
                            </td>
                            <td>£<?php echo number_format($cos['cost'], 2); ?></td>
                            <td>
                                <?php if ($cos['expiry_date']): ?>
                                    <?php echo date('d/m/Y', strtotime($cos['expiry_date'])); ?>
                                    <?php if ($cos['days_to_expiry'] !== null && $cos['days_to_expiry'] < 30 && $cos['days_to_expiry'] > 0): ?>
                                        <span class="badge bg-warning"><?php echo $cos['days_to_expiry']; ?> days</span>
                                    <?php elseif ($cos['days_to_expiry'] < 0): ?>
                                        <span class="badge bg-danger">Expired</span>
                                    <?php endif; ?>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="edit.php?id=<?php echo $cos['id']; ?>" class="btn btn-sm btn-outline-primary" title="Edit">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <?php if ($cos['status'] === 'assigned'): ?>
                                <a href="use.php?id=<?php echo $cos['id']; ?>" class="btn btn-sm btn-outline-success" title="Mark as Used">
                                    <i class="bi bi-check-circle"></i>
                                </a>
                                <?php endif; ?>
                                <a href="delete.php?id=<?php echo $cos['id']; ?>" class="btn btn-sm btn-outline-danger" title="Delete CoS">
                                    <i class="bi bi-trash"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<style>
.stat-card {
    padding: 1.5rem;
    border-radius: 0.5rem;
    text-align: center;
}

.stat-value {
    font-size: 2rem;
    font-weight: bold;
    margin-bottom: 0.5rem;
}

.stat-label {
    font-size: 0.875rem;
    opacity: 0.9;
}
</style>

<?php
// Only include footer if not embedded
if (!defined('MODULE_EMBEDDED')) {
    require_once '../../includes/footer.php';
}
?>
