<?php
$page_title = 'Certificate of Sponsorship Management';
require_once '../../includes/header.php';

// Fetch CoS statistics
$stats_sql = "SELECT
    COUNT(*) as total,
    SUM(CASE WHEN status = 'available' THEN 1 ELSE 0 END) as available,
    SUM(CASE WHEN status = 'assigned' THEN 1 ELSE 0 END) as assigned,
    SUM(CASE WHEN status = 'used' THEN 1 ELSE 0 END) as used,
    SUM(CASE WHEN status = 'withdrawn' THEN 1 ELSE 0 END) as withdrawn,
    SUM(CASE WHEN status = 'expired' THEN 1 ELSE 0 END) as expired,
    SUM(CASE WHEN expiry_date <= CURDATE() + INTERVAL 30 DAY AND expiry_date >= CURDATE() AND status = 'available' THEN 1 ELSE 0 END) as expiring_soon,
    SUM(CASE WHEN cos_type = 'defined' THEN 1 ELSE 0 END) as defined_count,
    SUM(CASE WHEN cos_type = 'undefined' THEN 1 ELSE 0 END) as undefined_count,
    SUM(cost) as total_cost,
    SUM(CASE WHEN status IN ('assigned', 'used') THEN cost ELSE 0 END) as spent_cost
FROM " . DB_PREFIX . "cos_records";

$stmt = $pdo->query($stats_sql);
$stats = $stmt->fetch(PDO::FETCH_ASSOC);

// Recent CoS records
$recent_sql = "SELECT cr.*, sw.full_name as worker_name
FROM " . DB_PREFIX . "cos_records cr
LEFT JOIN " . DB_PREFIX . "sponsored_workers sw ON cr.assigned_to = sw.id
ORDER BY cr.created_at DESC
LIMIT 10";

$recent_stmt = $pdo->query($recent_sql);
$recent_cos = $recent_stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!-- Visual Debug Indicator -->
<div style="position: fixed; top: 70px; right: 20px; background: #10b981; color: white; padding: 10px 20px; border-radius: 8px; z-index: 9999; font-weight: bold; box-shadow: 0 4px 12px rgba(0,0,0,0.3);">
    ✓ NEW VERSION LOADED - <?= date('H:i:s') ?>
</div>

<style>
.premium-card {
    background: linear-gradient(135deg, var(--gradient-start) 0%, var(--gradient-end) 100%);
    border: none;
    border-radius: 20px;
    padding: 32px;
    color: #fff !important;
    position: relative;
    overflow: hidden;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
}

.premium-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.25);
}

.premium-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 100%);
    opacity: 0;
    transition: opacity 0.4s ease;
}

.premium-card:hover::before {
    opacity: 1;
}

.card-icon {
    width: 64px;
    height: 64px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 28px;
    margin-bottom: 20px;
    backdrop-filter: blur(10px);
    color: #fff !important;
}

.card-number {
    font-size: 48px;
    font-weight: 700;
    line-height: 1;
    margin-bottom: 8px;
    text-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
    color: #fff !important;
}

.card-label {
    font-size: 14px;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 1.5px;
    opacity: 0.95;
    text-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
    color: #fff !important;
}

.gradient-primary { --gradient-start: #667eea; --gradient-end: #764ba2; }
.gradient-success { --gradient-start: #56ab2f; --gradient-end: #a8e063; }
.gradient-warning { --gradient-start: #f2994a; --gradient-end: #f2c94c; }
.gradient-danger { --gradient-start: #eb3349; --gradient-end: #f45c43; }
.gradient-info { --gradient-start: #4facfe; --gradient-end: #00f2fe; }
.gradient-secondary { --gradient-start: #8e9eab; --gradient-end: #eef2f3; }

.detail-card {
    background: var(--bg-secondary);
    border: 1px solid var(--border-color);
    border-radius: 16px;
    padding: 24px;
    transition: all 0.3s ease;
}

.detail-card:hover {
    border-color: #667eea;
    box-shadow: 0 8px 24px rgba(102, 126, 234, 0.15);
}

.detail-icon {
    width: 48px;
    height: 48px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #fff;
    font-size: 24px;
}

.detail-number {
    font-size: 32px;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 4px;
}

.detail-label {
    font-size: 13px;
    font-weight: 500;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 1px;
}

[data-theme="dark"] .detail-card {
    background: var(--bg-tertiary);
}
</style>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-file-earmark-text"></i> Certificate of Sponsorship Management</h4>
    <a href="add.php" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Add New CoS
    </a>
</div>

<!-- Premium Stats Cards -->
<div class="row g-4 mb-4">
    <div class="col-md-4">
        <div class="premium-card gradient-primary">
            <div class="card-icon">
                <i class="bi bi-files"></i>
            </div>
            <div class="card-number"><?= number_format($stats['total'] ?? 0) ?></div>
            <div class="card-label">Total CoS Records</div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="premium-card gradient-success">
            <div class="card-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="card-number"><?= number_format($stats['available'] ?? 0) ?></div>
            <div class="card-label">Available</div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="premium-card gradient-info">
            <div class="card-icon">
                <i class="bi bi-person-check"></i>
            </div>
            <div class="card-number"><?= number_format($stats['assigned'] ?? 0) ?></div>
            <div class="card-label">Assigned to Workers</div>
        </div>
    </div>
</div>

<div class="row g-4 mb-4">
    <div class="col-md-4">
        <div class="premium-card gradient-secondary">
            <div class="card-icon">
                <i class="bi bi-check2-all"></i>
            </div>
            <div class="card-number"><?= number_format($stats['used'] ?? 0) ?></div>
            <div class="card-label">Used</div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="premium-card gradient-warning">
            <div class="card-icon">
                <i class="bi bi-clock-history"></i>
            </div>
            <div class="card-number"><?= number_format($stats['expiring_soon'] ?? 0) ?></div>
            <div class="card-label">Expiring Soon</div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="premium-card gradient-danger">
            <div class="card-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="card-number"><?= number_format($stats['expired'] ?? 0) ?></div>
            <div class="card-label">Expired</div>
        </div>
    </div>
</div>

<!-- Detail Cards -->
<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="detail-card">
            <div class="d-flex align-items-center gap-3">
                <div class="detail-icon">
                    <i class="bi bi-person-badge"></i>
                </div>
                <div>
                    <div class="detail-number"><?= number_format($stats['defined_count'] ?? 0) ?></div>
                    <div class="detail-label">Defined CoS</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="detail-card">
            <div class="d-flex align-items-center gap-3">
                <div class="detail-icon">
                    <i class="bi bi-file-earmark"></i>
                </div>
                <div>
                    <div class="detail-number"><?= number_format($stats['undefined_count'] ?? 0) ?></div>
                    <div class="detail-label">Undefined CoS</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="detail-card">
            <div class="d-flex align-items-center gap-3">
                <div class="detail-icon">
                    <i class="bi bi-currency-pound"></i>
                </div>
                <div>
                    <div class="detail-number">£<?= number_format($stats['total_cost'] ?? 0) ?></div>
                    <div class="detail-label">Total Cost</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="detail-card">
            <div class="d-flex align-items-center gap-3">
                <div class="detail-icon">
                    <i class="bi bi-cash-coin"></i>
                </div>
                <div>
                    <div class="detail-number">£<?= number_format($stats['spent_cost'] ?? 0) ?></div>
                    <div class="detail-label">Spent</div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent CoS Records -->
<div class="stat-card">
    <h5 class="mb-4"><i class="bi bi-clock-history"></i> Recent CoS Records</h5>

    <?php if (empty($recent_cos)): ?>
        <div class="alert alert-info text-center">
            <i class="bi bi-inbox" style="font-size: 48px;"></i>
            <p class="mt-2">No CoS records found. Add your first CoS to get started.</p>
            <a href="add.php" class="btn btn-primary mt-2">
                <i class="bi bi-plus-circle"></i> Add First CoS
            </a>
        </div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>CoS Number</th>
                        <th>Type</th>
                        <th>Status</th>
                        <th>Assigned To</th>
                        <th>Issue Date</th>
                        <th>Expiry Date</th>
                        <th>Cost</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recent_cos as $cos): ?>
                    <tr>
                        <td><strong><?= htmlspecialchars($cos['cos_number']) ?></strong></td>
                        <td>
                            <span class="badge <?= $cos['cos_type'] === 'defined' ? 'bg-primary' : 'bg-info' ?>">
                                <?= ucfirst($cos['cos_type']) ?>
                            </span>
                        </td>
                        <td>
                            <?php
                            $badge_class = match($cos['status']) {
                                'available' => 'bg-success',
                                'assigned' => 'bg-info',
                                'used' => 'bg-secondary',
                                'withdrawn' => 'bg-warning',
                                'expired' => 'bg-danger',
                                default => 'bg-secondary'
                            };
                            ?>
                            <span class="badge <?= $badge_class ?>">
                                <?= ucfirst($cos['status']) ?>
                            </span>
                        </td>
                        <td><?= $cos['worker_name'] ? htmlspecialchars($cos['worker_name']) : '-' ?></td>
                        <td><?= date('d/m/Y', strtotime($cos['issue_date'])) ?></td>
                        <td>
                            <?php
                            $expiry = strtotime($cos['expiry_date']);
                            $now = time();
                            $days_diff = floor(($expiry - $now) / 86400);
                            ?>
                            <?= date('d/m/Y', $expiry) ?>
                            <?php if ($days_diff > 0 && $days_diff <= 30): ?>
                                <span class="badge bg-warning text-dark ms-1"><?= $days_diff ?> days</span>
                            <?php elseif ($days_diff < 0): ?>
                                <span class="badge bg-danger ms-1">Expired</span>
                            <?php endif; ?>
                        </td>
                        <td>£<?= number_format($cos['cost'], 2) ?></td>
                        <td>
                            <a href="view.php?id=<?= $cos['id'] ?>" class="btn btn-sm btn-outline-primary" title="View">
                                <i class="bi bi-eye"></i>
                            </a>
                            <a href="edit.php?id=<?= $cos['id'] ?>" class="btn btn-sm btn-outline-warning" title="Edit">
                                <i class="bi bi-pencil"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="text-center mt-3">
            <a href="list.php" class="btn btn-outline-primary">
                View All CoS Records <i class="bi bi-arrow-right"></i>
            </a>
        </div>
    <?php endif; ?>
</div>

<?php require_once '../../includes/footer.php'; ?>
