<?php
session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';
require_once '../../includes/session_manager.php';

require_authentication();
require_permission(70);

// Get current user
$current_user = get_logged_in_user();
if (!$current_user) {
    header('Location: ../../login.php');
    exit;
}

$page_title = 'Edit CoS';
$errors = [];
$cos_id = $_GET['id'] ?? 0;

// Fetch CoS record
$stmt = $pdo->prepare("SELECT * FROM " . DB_PREFIX . "cos_records WHERE id = ?");
$stmt->execute([$cos_id]);
$cos = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$cos) {
    $_SESSION['error'] = 'CoS record not found';
    header('Location: list.php');
    exit;
}

// Get workers for assignment
$workers = $pdo->query("SELECT id, full_name, employee_number FROM " . DB_PREFIX . "sponsored_workers WHERE status = 'active' ORDER BY full_name")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cos_number = trim($_POST['cos_number'] ?? '');
    $issue_date = $_POST['issue_date'] ?? '';
    $assigned_to = $_POST['assigned_to'] ?: null;
    $status = $_POST['status'] ?? 'assigned';
    $cost = $_POST['cost'] ?? 0;
    $expiry_date = $_POST['expiry_date'] ?: null;
    $notes = trim($_POST['notes'] ?? '');

    if (empty($cos_number)) $errors[] = "CoS number is required";
    if (empty($issue_date)) $errors[] = "Issue date is required";

    if (empty($errors)) {
        try {
            $stmt = $pdo->prepare("UPDATE " . DB_PREFIX . "cos_records
                SET cos_number = ?, issue_date = ?, assigned_to = ?, status = ?,
                    cost = ?, expiry_date = ?, notes = ?, updated_at = NOW()
                WHERE id = ?");

            $stmt->execute([$cos_number, $issue_date, $assigned_to, $status, $cost, $expiry_date, $notes, $cos_id]);

            $_SESSION['success'] = 'CoS updated successfully';
            header('Location: list.php');
            exit;
        } catch (PDOException $e) {
            $errors[] = "Database error: " . $e->getMessage();
        }
    }
} else {
    // Pre-fill form with existing data
    $_POST = $cos;
}

include '../../includes/header.php';
?>

<div class="dashboard-container">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="modern-card">
                <div class="card-header-modern">
                    <h5 class="card-title-modern"><i class="bi bi-pencil"></i> Edit Certificate of Sponsorship</h5>
                </div>
                <div class="card-body-modern">
                    <?php if (!empty($errors)): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0"><?php foreach ($errors as $error): ?><li><?php echo htmlspecialchars($error); ?></li><?php endforeach; ?></ul>
                        </div>
                    <?php endif; ?>

                    <form method="POST">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">CoS Number <span class="text-danger">*</span></label>
                                <input type="text" name="cos_number" class="form-control" required value="<?php echo htmlspecialchars($_POST['cos_number'] ?? ''); ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Issue Date <span class="text-danger">*</span></label>
                                <input type="date" name="issue_date" class="form-control" required value="<?php echo htmlspecialchars($_POST['issue_date'] ?? ''); ?>">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Assign To Worker</label>
                                <select name="assigned_to" class="form-select">
                                    <option value="">Unassigned</option>
                                    <?php foreach ($workers as $worker): ?>
                                        <option value="<?php echo $worker['id']; ?>" <?php echo ($_POST['assigned_to'] ?? '') == $worker['id'] ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($worker['full_name']); ?> (<?php echo $worker['employee_number']; ?>)
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Status</label>
                                <select name="status" class="form-select">
                                    <option value="assigned" <?php echo ($_POST['status'] ?? '') === 'assigned' ? 'selected' : ''; ?>>Assigned</option>
                                    <option value="used" <?php echo ($_POST['status'] ?? '') === 'used' ? 'selected' : ''; ?>>Used</option>
                                    <option value="withdrawn" <?php echo ($_POST['status'] ?? '') === 'withdrawn' ? 'selected' : ''; ?>>Withdrawn</option>
                                    <option value="expired" <?php echo ($_POST['status'] ?? '') === 'expired' ? 'selected' : ''; ?>>Expired</option>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Cost (£)</label>
                                <input type="number" name="cost" class="form-control" step="0.01" value="<?php echo htmlspecialchars($_POST['cost'] ?? '0'); ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Expiry Date</label>
                                <input type="date" name="expiry_date" class="form-control" value="<?php echo htmlspecialchars($_POST['expiry_date'] ?? ''); ?>">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Notes</label>
                            <textarea name="notes" class="form-control" rows="3"><?php echo htmlspecialchars($_POST['notes'] ?? ''); ?></textarea>
                        </div>

                        <hr>
                        <div class="d-flex justify-content-between">
                            <a href="list.php" class="btn btn-secondary"><i class="bi bi-x-circle"></i> Cancel</a>
                            <button type="submit" class="btn btn-primary"><i class="bi bi-check-circle"></i> Update CoS</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>
