<?php
// Check if embedded through router
if (!defined('MODULE_EMBEDDED')) {
    session_start();
    require_once '../../config/database.php';
    require_once '../../includes/database.php';
    require_once '../../includes/session_manager.php';
    require_authentication();
    require_permission(70);
}

// Get current user
$current_user = get_logged_in_user();
if (!$current_user) {
    if (defined('MODULE_EMBEDDED')) {
        header('Location: ../../login.php');
    } else {
        header('Location: ../../login.php');
    }
    exit;
}

$page_title = 'Add CoS';
$current_page = 'cos';
$errors = [];

// Get database connection
$pdo = get_database_connection();

// Get workers for assignment (only active workers without deleted status)
$workers = $pdo->query("SELECT id, full_name, employee_number, job_title FROM " . DB_PREFIX . "sponsored_workers WHERE status = 'active' AND deleted_at IS NULL ORDER BY full_name")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Basic fields
    $cos_number = trim($_POST['cos_number'] ?? '');
    $cos_type = $_POST['cos_type'] ?? 'defined';
    $issue_date = $_POST['issue_date'] ?? '';
    $assigned_to = $_POST['assigned_to'] ?: null;
    $status = $_POST['status'] ?? 'assigned';
    $expiry_date = $_POST['expiry_date'] ?: null;

    // Job details
    $job_title = trim($_POST['job_title'] ?? '');
    $soc_code = trim($_POST['soc_code'] ?? '');
    $salary = $_POST['salary'] ?: null;
    $start_date = $_POST['start_date'] ?: null;
    $end_date = $_POST['end_date'] ?: null;

    // Cost (UK Home Office CoS pricing)
    $cost = $_POST['cost'] ?? 0;

    $notes = trim($_POST['notes'] ?? '');

    // Validation
    if (empty($cos_number)) $errors[] = "CoS number is required";
    if (empty($issue_date)) $errors[] = "Issue date is required";

    if (empty($errors)) {
        try {
            $stmt = $pdo->prepare("INSERT INTO " . DB_PREFIX . "cos_records
                (cos_number, cos_type, issue_date, assigned_to, status, cost, expiry_date,
                 job_title, soc_code, salary, start_date, end_date, notes, created_by, created_at)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");

            $stmt->execute([
                $cos_number, $cos_type, $issue_date, $assigned_to, $status, $cost, $expiry_date,
                $job_title, $soc_code, $salary, $start_date, $end_date, $notes, $current_user['id']
            ]);

            $_SESSION['success'] = 'CoS added successfully';

            // Redirect based on how the page was accessed
            if (defined('MODULE_EMBEDDED')) {
                header('Location: ../../m/cos/list?success=1');
            } else {
                header('Location: list.php?success=1');
            }
            exit;
        } catch (PDOException $e) {
            $errors[] = "Database error: " . $e->getMessage();
        }
    }
}

// Only include header if not embedded through router
if (!defined('MODULE_EMBEDDED')) {
    include '../../includes/header.php';
}
?>

<style>
.form-section {
    background: var(--card-bg);
    border: 1px solid var(--border-color);
    border-radius: 8px;
    padding: 20px;
    margin-bottom: 20px;
}

.form-section-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--primary-color);
    margin-bottom: 15px;
    padding-bottom: 10px;
    border-bottom: 2px solid var(--primary-color);
    display: flex;
    align-items: center;
    gap: 8px;
}
</style>

<div class="row justify-content-center">
    <div class="col-12">
        <div class="modern-card">
            <div class="card-header-modern">
                <h5 class="card-title-modern">
                    <i class="bi bi-file-earmark-text"></i> Add Certificate of Sponsorship
                </h5>
            </div>
            <div class="card-body-modern">
                <?php if (!empty($errors)): ?>
                    <div class="alert alert-danger">
                        <i class="bi bi-exclamation-triangle"></i>
                        <ul class="mb-0">
                            <?php foreach ($errors as $error): ?>
                                <li><?php echo htmlspecialchars($error); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form method="POST" id="cosForm">
                    <!-- Basic CoS Information -->
                    <div class="form-section">
                        <div class="form-section-title">
                            <i class="bi bi-card-text"></i> CoS Information
                        </div>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">CoS Number <span class="text-danger">*</span></label>
                                <input type="text" name="cos_number" class="form-control" required
                                       placeholder="e.g., ABC123456789"
                                       value="<?php echo htmlspecialchars($_POST['cos_number'] ?? ''); ?>">
                                <small class="text-muted">Home Office CoS reference number</small>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">CoS Type <span class="text-danger">*</span></label>
                                <select name="cos_type" class="form-select" required>
                                    <option value="defined" <?php echo ($_POST['cos_type'] ?? 'defined') === 'defined' ? 'selected' : ''; ?>>Defined CoS</option>
                                    <option value="undefined" <?php echo ($_POST['cos_type'] ?? '') === 'undefined' ? 'selected' : ''; ?>>Undefined CoS</option>
                                </select>
                                <small class="text-muted">Type allocated by Home Office</small>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Issue Date <span class="text-danger">*</span></label>
                                <input type="date" name="issue_date" class="form-control" required
                                       value="<?php echo htmlspecialchars($_POST['issue_date'] ?? date('Y-m-d')); ?>">
                                <small class="text-muted">Date issued by Home Office</small>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Status</label>
                                <select name="status" class="form-select">
                                    <option value="assigned" selected>Assigned</option>
                                    <option value="used">Used</option>
                                    <option value="withdrawn">Withdrawn</option>
                                    <option value="expired">Expired</option>
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Cost (£)</label>
                                <select name="cost" class="form-select" id="costSelect">
                                    <option value="0">£0 - Free allocation</option>
                                    <option value="239" selected>£239 - Standard (Small/Charitable Sponsor)</option>
                                    <option value="364">£364 - Medium/Large Sponsor (Standard)</option>
                                    <option value="536">£536 - Priority Service</option>
                                    <option value="1000">£1,000 - Fast Track</option>
                                </select>
                                <small class="text-muted">UK Home Office CoS fees (2024)</small>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Expiry Date</label>
                                <input type="date" name="expiry_date" class="form-control"
                                       value="<?php echo htmlspecialchars($_POST['expiry_date'] ?? ''); ?>">
                                <small class="text-muted">When CoS expires if unused</small>
                            </div>
                        </div>
                    </div>

                    <!-- Worker Assignment -->
                    <div class="form-section">
                        <div class="form-section-title">
                            <i class="bi bi-person-badge"></i> Worker Assignment
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label class="form-label">Assign To Worker</label>
                                <select name="assigned_to" class="form-select" id="workerSelect">
                                    <option value="">-- Unassigned / Pool --</option>
                                    <?php foreach ($workers as $worker): ?>
                                        <option value="<?php echo $worker['id']; ?>"
                                                data-jobtitle="<?php echo htmlspecialchars($worker['job_title'] ?? ''); ?>"
                                                <?php echo ($_POST['assigned_to'] ?? '') == $worker['id'] ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($worker['full_name']); ?>
                                            (<?php echo htmlspecialchars($worker['employee_number']); ?>)
                                            <?php if ($worker['job_title']): ?>
                                                - <?php echo htmlspecialchars($worker['job_title']); ?>
                                            <?php endif; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                                <small class="text-muted">Leave blank to keep in unassigned pool</small>
                            </div>
                        </div>
                    </div>

                    <!-- Job Details -->
                    <div class="form-section">
                        <div class="form-section-title">
                            <i class="bi bi-briefcase"></i> Job Details on CoS
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Job Title</label>
                                <input type="text" name="job_title" class="form-control" id="jobTitleInput"
                                       placeholder="e.g., Software Developer"
                                       value="<?php echo htmlspecialchars($_POST['job_title'] ?? ''); ?>">
                                <small class="text-muted">Job title as stated on CoS</small>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">SOC Code</label>
                                <input type="text" name="soc_code" class="form-control"
                                       placeholder="e.g., 2136"
                                       value="<?php echo htmlspecialchars($_POST['soc_code'] ?? ''); ?>">
                                <small class="text-muted">Standard Occupational Classification code</small>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Annual Salary (£)</label>
                                <input type="number" name="salary" class="form-control" step="0.01"
                                       placeholder="e.g., 38700"
                                       value="<?php echo htmlspecialchars($_POST['salary'] ?? ''); ?>">
                                <small class="text-muted">Salary specified on CoS</small>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Start Date</label>
                                <input type="date" name="start_date" class="form-control"
                                       value="<?php echo htmlspecialchars($_POST['start_date'] ?? ''); ?>">
                                <small class="text-muted">Intended employment start date</small>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">End Date</label>
                                <input type="date" name="end_date" class="form-control"
                                       value="<?php echo htmlspecialchars($_POST['end_date'] ?? ''); ?>">
                                <small class="text-muted">Intended employment end date</small>
                            </div>
                        </div>
                    </div>

                    <!-- Notes -->
                    <div class="form-section">
                        <div class="form-section-title">
                            <i class="bi bi-journal-text"></i> Additional Notes
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Notes</label>
                            <textarea name="notes" class="form-control" rows="4"
                                      placeholder="Additional information, special conditions, or comments..."><?php echo htmlspecialchars($_POST['notes'] ?? ''); ?></textarea>
                        </div>
                    </div>

                    <hr class="my-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <a href="<?php echo defined('MODULE_EMBEDDED') ? '../../m/cos/list' : 'list.php'; ?>"
                           class="btn btn-secondary">
                            <i class="bi bi-x-circle"></i> Cancel
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-circle"></i> Add Certificate of Sponsorship
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
// Auto-populate job title when worker is selected
document.getElementById('workerSelect')?.addEventListener('change', function() {
    const selectedOption = this.options[this.selectedIndex];
    const jobTitle = selectedOption.getAttribute('data-jobtitle');
    const jobTitleInput = document.getElementById('jobTitleInput');

    if (jobTitle && jobTitleInput && !jobTitleInput.value) {
        jobTitleInput.value = jobTitle;
    }
});
</script>

<?php
// Only include footer if not embedded through router
if (!defined('MODULE_EMBEDDED')) {
    include '../../includes/footer.php';
}
?>
