# CoS Management Module

**Version:** 1.0.0
**Status:** ✅ Production Ready
**Module ID:** `cos`

---

## Overview

The Certificate of Sponsorship (CoS) Management module helps UK sponsors track, assign, and manage Certificates of Sponsorship in compliance with Home Office Appendix D requirements. It provides complete visibility over CoS allocation, usage, costs, and helps ensure compliance with sponsor duties.

---

## Features

### ✅ Core Features
1. **CoS Tracking** - Track all defined and undefined CoS
2. **Assignment Management** - Assign CoS to sponsored workers
3. **Status Tracking** - Monitor CoS status (assigned, used, withdrawn, expired)
4. **Cost Management** - Track CoS costs and budget
5. **Expiry Alerts** - Automatic alerts for expiring CoS
6. **History & Audit Trail** - Complete audit log of all CoS changes
7. **Document Storage** - Store CoS PDFs and related documents
8. **Home Office Compliance** - Track withdrawal reporting requirements

### 📋 CRUD Operations
- ✅ **List/View** - Search, filter, and view all CoS records
- ✅ **Add** - Create new CoS records
- ✅ **Edit** - Update CoS details
- ✅ **View** - Detailed CoS information with worker assignment
- ✅ **Use** - Mark assigned CoS as used
- ✅ **Withdraw** - Withdraw CoS with reason tracking
- ✅ **Delete** - Permanently remove CoS records

---

## Database Schema

### Tables Created
1. **scms_cos_records** - Main CoS tracking table
2. **scms_cos_history** - Audit trail of all changes
3. **scms_cos_documents** - CoS-related documents

### Key Fields
- `cos_number` - Unique CoS reference from Home Office
- `cos_type` - Defined or Undefined
- `issue_date` - Date issued by Home Office
- `assigned_to` - Worker ID (FK to scms_sponsored_workers)
- `status` - assigned | used | withdrawn | expired
- `cost` - Cost in GBP
- `expiry_date` - When CoS expires if unused
- `job_title`, `soc_code`, `salary` - CoS details

---

## File Structure

```
/modules/cos/
├── module.json           # Module configuration
├── list.php             # Main list page with statistics
├── add.php              # Add new CoS
├── edit.php             # Edit CoS details
├── view.php             # View CoS with full details
├── use.php              # Mark CoS as used
├── withdraw.php         # Withdraw CoS with reason
├── delete.php           # Delete CoS record
├── database_schema.sql  # Complete database schema
└── README.md           # This file
```

---

## UK Home Office Compliance

### CoS Types
- **Defined CoS** (£199) - Specific worker, specific role
- **Undefined CoS** (£25) - Generic, can be assigned later

### Reportable Events (within 10 working days)
- ✅ CoS assigned to worker
- ✅ Worker starts work (CoS marked as "used")
- ✅ CoS withdrawn before use
- ✅ Worker fails to start work

### Module Features
- Automatic status tracking
- Withdrawal reason recording
- Audit trail of all actions
- Cost tracking for budgeting
- Expiry date monitoring

---

## Installation

1. **Activate Module**
   - Go to Settings → Modules
   - Find "CoS Management"
   - Click "Activate"

2. **Create Database Tables**
   ```bash
   mysql -u username -p database_name < modules/cos/database_schema.sql
   ```

3. **Configure Settings** (Optional)
   - Settings → Modules → CoS Management
   - Set default CoS costs
   - Set alert days before expiry

4. **Set Permissions**
   - `cos.view` (Level 30+) - View CoS records
   - `cos.add` (Level 70+) - Add new CoS
   - `cos.edit` (Level 70+) - Edit CoS
   - `cos.assign` (Level 70+) - Assign to workers
   - `cos.withdraw` (Level 80+) - Withdraw CoS
   - `cos.delete` (Level 90+) - Delete records

---

## Usage Guide

### Adding a New CoS

1. Navigate to **CoS Management**
2. Click **Add CoS**
3. Enter:
   - CoS Number (from Home Office)
   - Issue Date
   - CoS Type (Defined/Undefined)
   - Cost (pre-filled from settings)
   - Assign to Worker (optional)
   - Expiry Date
4. Click **Add CoS**

### Assigning CoS to Worker

**Option 1: During Creation**
- Select worker from "Assign To Worker" dropdown when adding CoS

**Option 2: Edit Existing**
1. Find CoS in list
2. Click **Edit**
3. Select worker from dropdown
4. Click **Update CoS**

### Marking CoS as Used

1. Find assigned CoS in list
2. Click **✓** (Use) button
3. Confirm action
4. Status changes to "Used"

### Withdrawing CoS

1. Find CoS in list
2. Click **View** or **Edit**
3. Click **Withdraw CoS**
4. Enter detailed reason (for Home Office reporting)
5. Click **Confirm Withdrawal**
6. CoS status changes to "Withdrawn"
7. **IMPORTANT:** Report to Home Office within 10 working days

---

## Statistics Dashboard

The module provides real-time statistics:

- **Total CoS** - All CoS records in system
- **Assigned** - CoS assigned to workers
- **Used** - CoS that have been used
- **Withdrawn** - CoS that were withdrawn
- **Expired** - CoS that have expired
- **Total Cost** - Sum of all CoS costs

---

## Search & Filters

**Search by:**
- CoS number
- Worker name
- Employee number

**Filter by:**
- Status (Assigned, Used, Withdrawn, Expired)

---

## Integration with Other Modules

### Workers Module
- View CoS assigned to specific worker
- Worker profile shows CoS details
- Automatic linking when CoS assigned

### Reports Module
- CoS usage reports
- Cost analysis
- Expiry forecasts
- Compliance reports

---

## Settings

Configure via Settings → Modules → CoS Management:

1. **Defined CoS Cost** - Default cost for defined CoS (£199)
2. **Undefined CoS Cost** - Default cost for undefined CoS (£25)
3. **Alert Days Before Expiry** - Show alerts X days before expiry (default: 30)

---

## Permissions Matrix

| Action | Permission Level | Description |
|--------|-----------------|-------------|
| View List | 30+ | View all CoS records |
| Add CoS | 70+ | Create new CoS |
| Edit CoS | 70+ | Modify CoS details |
| Assign to Worker | 70+ | Assign CoS to worker |
| Mark as Used | 70+ | Change status to used |
| Withdraw CoS | 80+ | Withdraw with reason |
| Delete CoS | 90+ | Permanently delete |

---

## Security Features

- ✅ Permission-based access control
- ✅ SQL injection protection (prepared statements)
- ✅ XSS prevention (output escaping)
- ✅ CSRF token validation
- ✅ Complete audit trail
- ✅ Secure file uploads
- ✅ Input validation

---

## Technical Details

**Language:** PHP 7.4+
**Database:** MySQL/MariaDB
**Frontend:** Bootstrap 5, Dark Mode Compatible
**Dependencies:** Workers module

---

## Troubleshooting

### CoS not appearing in list
- Check database connection
- Verify module is activated
- Check user permissions (minimum level 30)

### Cannot assign to worker
- Ensure Workers module is installed and active
- Verify worker status is "active"
- Check permission level (70+ required)

### Expiry alerts not showing
- Check Settings → Modules → CoS Management
- Verify "Alert Days Before Expiry" is set
- Ensure expiry_date is populated

---

## Support

- **Documentation:** `/docs/modules/cos/`
- **Home Office Guidance:** [Appendix D - Sponsor Guidance](https://www.gov.uk/government/publications/workers-and-temporary-workers-guidance-for-sponsors-part-2-sponsor-a-worker)
- **Technical Support:** Contact system administrator

---

## Future Enhancements

Planned for v1.1:
- [ ] Bulk CoS import from Excel
- [ ] Direct Home Office SMS integration
- [ ] Automatic expiry notifications via email
- [ ] CoS allocation planning tool
- [ ] Advanced reporting dashboard
- [ ] Document scanning with OCR

---

**Last Updated:** October 17, 2025
**Module Status:** ✅ Production Ready
**Compliance:** UK Home Office Appendix D
