<?php
/**
 * Update Roster Overrides Table to Support Leave Authorization
 * Adds fields needed for authorizing leaves via roster page
 */
require_once '../../config/database.php';
require_once '../../includes/database.php';

try {
    $pdo = get_database_connection();

    echo "Updating roster_overrides table to support leave authorization...\n\n";

    // 1. Update override_type to include 'leave'
    echo "1. Updating override_type ENUM to include 'leave'...\n";
    $sql = "ALTER TABLE " . DB_PREFIX . "roster_overrides
            MODIFY COLUMN override_type ENUM('add', 'remove', 'leave') NOT NULL DEFAULT 'add'";
    $pdo->exec($sql);
    echo "   ✓ override_type updated\n\n";

    // 2. Add absence_type field
    echo "2. Adding absence_type field...\n";
    $sql = "ALTER TABLE " . DB_PREFIX . "roster_overrides
            ADD COLUMN absence_type ENUM('PL', 'FO', 'HO', 'UL', 'ML') NULL AFTER override_type";
    $pdo->exec($sql);
    echo "   ✓ absence_type added\n\n";

    // 3. Add half_day_period field
    echo "3. Adding half_day_period field...\n";
    $sql = "ALTER TABLE " . DB_PREFIX . "roster_overrides
            ADD COLUMN half_day_period ENUM('first_half', 'second_half', 'custom') NULL AFTER absence_type";
    $pdo->exec($sql);
    echo "   ✓ half_day_period added\n\n";

    // 4. Add time_from and time_to for custom half-day periods
    echo "4. Adding time_from and time_to fields...\n";
    $sql = "ALTER TABLE " . DB_PREFIX . "roster_overrides
            ADD COLUMN time_from TIME NULL AFTER half_day_period,
            ADD COLUMN time_to TIME NULL AFTER time_from";
    $pdo->exec($sql);
    echo "   ✓ time_from and time_to added\n\n";

    echo "✓ Successfully updated roster_overrides table!\n";
    echo "\nNew fields added:\n";
    echo "- override_type: Now supports 'add', 'remove', 'leave'\n";
    echo "- absence_type: PL, FO, HO, UL, ML\n";
    echo "- half_day_period: first_half, second_half, custom\n";
    echo "- time_from, time_to: For custom half-day periods\n";

} catch (PDOException $e) {
    // Check if columns already exist
    if (strpos($e->getMessage(), 'Duplicate column') !== false) {
        echo "✓ Table already has the required columns!\n";
    } else {
        echo "✗ Error: " . $e->getMessage() . "\n";
    }
}
?>
