<?php
/**
 * Test roster.php for errors
 */
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Simulate authenticated session
$_SESSION['user_id'] = 1;
$_SESSION['username'] = 'test';
$_SESSION['permission_level'] = 90;

try {
    require_once '../../config/database.php';
    require_once '../../includes/database.php';

    $pdo = get_database_connection();
    echo "✓ Database connection successful\n";

    // Test locations query
    $locations = $pdo->query("SELECT id, name FROM " . DB_PREFIX . "work_locations WHERE status = 'active' ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
    echo "✓ Locations query successful: " . count($locations) . " locations found\n";

    // Test workers query
    $workers = $pdo->query("SELECT id, full_name, employee_number FROM " . DB_PREFIX . "sponsored_workers WHERE status = 'active' ORDER BY full_name")->fetchAll(PDO::FETCH_ASSOC);
    echo "✓ Workers query successful: " . count($workers) . " workers found\n";

    if (empty($locations)) {
        echo "⚠ WARNING: No active locations found\n";
    }

    $selected_location = $locations[0]['id'] ?? 0;
    echo "✓ Selected location: " . $selected_location . "\n";

    if ($selected_location) {
        // Test shift patterns query
        $stmt = $pdo->prepare("SELECT id, shift_name, shift_type, start_time, end_time FROM " . DB_PREFIX . "location_shift_patterns WHERE location_id = ? ORDER BY start_time");
        $stmt->execute([$selected_location]);
        $shift_patterns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo "✓ Shift patterns query successful: " . count($shift_patterns) . " patterns found\n";
    }

    echo "\n✓ All tests passed - roster.php should work\n";

} catch (Exception $e) {
    echo "✗ ERROR: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
    echo "\nStack trace:\n" . $e->getTraceAsString() . "\n";
}
?>
