<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Don't load error_handler
session_start();

echo "Step 1: Session started<br>";

require_once '../../config/database.php';
echo "Step 2: Database config loaded<br>";

require_once '../../includes/database.php';
echo "Step 3: Database functions loaded<br>";

require_once '../../includes/session_manager.php';
echo "Step 4: Session manager loaded<br>";

try {
    $pdo = get_database_connection();
    echo "Step 5: Database connection established<br>";
} catch (Exception $e) {
    die("Database error: " . $e->getMessage());
}

echo "Step 6: Getting locations<br>";
try {
    $locations = $pdo->query("SELECT id, name FROM " . DB_PREFIX . "work_locations WHERE status = 'active' ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
    echo "Step 7: Found " . count($locations) . " locations<br>";
} catch (Exception $e) {
    die("Location query error: " . $e->getMessage());
}

echo "Step 8: Getting workers<br>";
try {
    $workers = $pdo->query("SELECT id, full_name, employee_number FROM " . DB_PREFIX . "sponsored_workers WHERE status = 'active' ORDER BY full_name")->fetchAll(PDO::FETCH_ASSOC);
    echo "Step 9: Found " . count($workers) . " workers<br>";
} catch (Exception $e) {
    die("Worker query error: " . $e->getMessage());
}

echo "Step 10: All queries successful<br>";
echo "Step 11: Including header<br>";

$page_title = 'Roster Test';
$current_page = 'attendance';

try {
    require_once '../../includes/header.php';
    echo "Step 12: Header included successfully<br>";
} catch (Exception $e) {
    die("Header error: " . $e->getMessage() . "<br>File: " . $e->getFile() . "<br>Line: " . $e->getLine());
}

echo "TEST COMPLETE - No errors!";
require_once '../../includes/footer.php';
?>
