<?php
/**
 * Direct test of roster.php to catch actual error
 */
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

echo "Starting roster test...\n<br>";

try {
    ob_start();
    include 'roster.php';
    $output = ob_get_clean();
    echo "✓ Roster.php loaded successfully\n<br>";
    echo "Output length: " . strlen($output) . " bytes\n<br>";
} catch (Throwable $e) {
    ob_end_clean();
    echo "✗ ERROR CAUGHT:\n<br>";
    echo "Message: " . $e->getMessage() . "\n<br>";
    echo "File: " . $e->getFile() . "\n<br>";
    echo "Line: " . $e->getLine() . "\n<br>";
    echo "\nStack trace:\n<br><pre>";
    echo $e->getTraceAsString();
    echo "</pre>\n";
}
?>
