<?php
session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';

$pdo = get_database_connection();

echo "<h3>Checking ML Records</h3>";

// Get all ML records
$stmt = $pdo->query("SELECT worker_id, attendance_date, status, created_at FROM " . DB_PREFIX . "attendance_records WHERE status = 'ML' ORDER BY attendance_date DESC LIMIT 20");
$ml_records = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<p>Found " . count($ml_records) . " ML records:</p>";
echo "<table border='1'>";
echo "<tr><th>Worker ID</th><th>Date</th><th>Status</th><th>Created At</th></tr>";
foreach ($ml_records as $record) {
    echo "<tr>";
    echo "<td>" . $record['worker_id'] . "</td>";
    echo "<td>" . $record['attendance_date'] . "</td>";
    echo "<td>" . $record['status'] . "</td>";
    echo "<td>" . $record['created_at'] . "</td>";
    echo "</tr>";
}
echo "</table>";

// Check October 2025 records for first worker
echo "<h3>October 2025 Records (First 10 days)</h3>";
$stmt = $pdo->query("SELECT worker_id, attendance_date, status FROM " . DB_PREFIX . "attendance_records WHERE attendance_date >= '2025-10-01' AND attendance_date <= '2025-10-10' ORDER BY worker_id, attendance_date");
$oct_records = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<p>Found " . count($oct_records) . " records:</p>";
echo "<table border='1'>";
echo "<tr><th>Worker ID</th><th>Date</th><th>Status</th></tr>";
foreach ($oct_records as $record) {
    echo "<tr>";
    echo "<td>" . $record['worker_id'] . "</td>";
    echo "<td>" . $record['attendance_date'] . "</td>";
    echo "<td>" . $record['status'] . "</td>";
    echo "</tr>";
}
echo "</table>";
?>
