<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';
require_once '../../includes/session_manager.php';

echo '<!DOCTYPE html><html><head><title>Test</title></head><body>';
echo '<h1>Testing Location View</h1>';

// Check session
echo '<p>Permission Level: ' . (['permission_level'] ?? 'NOT SET') . '</p>';

if (($_SESSION['permission_level'] ?? 0) < 30) {
    die('Access denied - permission too low');
}

// Get database
$pdo = get_database_connection();
echo '<p>Database: Connected</p>';

// Check locations
try {
    $locations = $pdo->query("SELECT id, name, status FROM " . DB_PREFIX . "work_locations LIMIT 10")->fetchAll(PDO::FETCH_ASSOC);
    echo '<p>Total locations in database: ' . count($locations) . '</p>';
    echo '<pre>';
    print_r($locations);
    echo '</pre>';
} catch (Exception $e) {
    echo '<p style="color:red;">Error: ' . $e->getMessage() . '</p>';
}

// Check if calendar_by_location.php exists
$file_exists = file_exists(__DIR__ . '/calendar_by_location.php');
echo '<p>calendar_by_location.php exists: ' . ($file_exists ? 'YES' : 'NO') . '</p>';
echo '<p>File size: ' . filesize(__DIR__ . '/calendar_by_location.php') . ' bytes</p>';

echo '</body></html>';
