<?php
session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';

$pdo = get_database_connection();

echo "<h3>Calendar Data Debug</h3>";

// Same query as calendar.php
$month = 10;
$year = 2025;
$first_day = '2025-10-01';
$last_day = '2025-10-31';

// Get all workers
$workers = $pdo->query("SELECT id, full_name, employee_number FROM " . DB_PREFIX . "sponsored_workers WHERE status = 'active' ORDER BY full_name")->fetchAll(PDO::FETCH_ASSOC);

echo "<h4>Workers:</h4>";
foreach ($workers as $worker) {
    echo "ID: " . $worker['id'] . " - " . $worker['full_name'] . " (" . $worker['employee_number'] . ")<br>";
}

// Get all attendance for the month
$attendance_stmt = $pdo->prepare("SELECT * FROM " . DB_PREFIX . "attendance_records WHERE attendance_date >= ? AND attendance_date <= ?");
$attendance_stmt->execute([$first_day, $last_day]);
$attendance_data = [];
foreach ($attendance_stmt->fetchAll(PDO::FETCH_ASSOC) as $record) {
    $key = $record['worker_id'] . '_' . $record['attendance_date'];
    $attendance_data[$key] = $record;
}

echo "<h4>Attendance Data Array (first 20 entries):</h4>";
$count = 0;
foreach ($attendance_data as $key => $record) {
    echo "$key => Status: " . $record['status'] . " (Date: " . $record['attendance_date'] . ")<br>";
    $count++;
    if ($count >= 20) break;
}

echo "<h4>Specific Check for Worker 2, Oct 1-8:</h4>";
for ($day = 1; $day <= 8; $day++) {
    $date = sprintf('2025-10-%02d', $day);
    $key = "2_" . $date;
    if (isset($attendance_data[$key])) {
        echo "Key: $key - Status: " . $attendance_data[$key]['status'] . " ✓<br>";
    } else {
        echo "Key: $key - NOT FOUND ✗<br>";
    }
}
?>
